(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    238440,       9048]*)
(*NotebookOutlinePosition[    239342,       9078]*)
(*  CellTagsIndexPosition[    239298,       9074]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Other Depictions of Oscillation"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"The solution functions that are found in this chapter can be interpreted in \
several ways. We have considered them to be members of a vector space. But \
the linearly independent solutions can be considered to be parametric \
representations of a plane curve (phase plane), or as parametric \
representations for a space curve if the dependence on the parameter t is \
depicted explicitly. \n\nIt is combinations of these ideas that are presented \
here."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Load the ParametricPlot3D package"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(<< Graphics`ParametricPlot3D`\)], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Show Phase Portrait"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"This is deliberately depicted in the t==0 plane, because the projections of \
the two linearly independent solutions are intimately connected with this \
representation."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p1 = 
        ParametricPlot3D[{0, E\^\(-\(t\/3\)\)\ Cos[6\ t], 
            E\^\(-\(t\/3\)\)\ Sin[6\ t]}, {t, 0, 3\ \[Pi],  .05}, 
          Boxed \[Rule] True, 
          PlotRange \[Rule] {{0, 3\ \[Pi]}, {\(-1\), 1}, {\(-1\), 1}}, 
          BoxRatios \[Rule] {3, 1, 1}];\)\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .67912 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0224888 1.02249 -0.150431 1.02249 [
[.02846 .27668 -2.67377 -9 ]
[.02846 .27668 3.32623 0 ]
[.18704 .22058 -2.78329 -9 ]
[.18704 .22058 3.21671 0 ]
[.35321 .1618 -2.90126 -9 ]
[.35321 .1618 3.09874 0 ]
[.52756 .10014 -3.0287 -9 ]
[.52756 .10014 2.9713 0 ]
[.71068 .0354 -3.1668 -9 ]
[.71068 .0354 2.8332 0 ]
[.86008 -0.00425 0 -6.08625 ]
[.86008 -0.00425 12 2.91375 ]
[.8924 .04484 0 -6.05064 ]
[.8924 .04484 24 2.94936 ]
[.92355 .09216 0 -6.0166 ]
[.92355 .09216 6 2.9834 ]
[.9536 .13781 0 -5.98402 ]
[.9536 .13781 18 3.01598 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 6 3.04719 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 12 3.04719 ]
[.9897 .2427 0 -5.91612 ]
[.9897 .2427 24 3.08388 ]
[.99701 .30533 0 -5.87841 ]
[.99701 .30533 6 3.12159 ]
[1.00453 .36986 0 -5.83963 ]
[1.00453 .36986 18 3.16037 ]
[1.01228 .43637 0 -5.79975 ]
[1.01228 .43637 6 3.20025 ]
[ 0 0 0 0 ]
[ 1 .67912 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.84803 0 m
.842 .00212 L
s
[(-1)] .86008 -0.00425 -1 .3525 Mshowa
.88031 .049 m
.87427 .05108 L
s
[(-0.5)] .8924 .04484 -1 .34459 Mshowa
.91144 .09624 m
.90538 .09828 L
s
[(0)] .92355 .09216 -1 .33702 Mshowa
.94146 .14181 m
.93539 .14381 L
s
[(0.5)] .9536 .13781 -1 .32978 Mshowa
.97045 .1858 m
.96437 .18777 L
s
[(1)] .98261 .18188 -1 .32285 Mshowa
.125 Mabswid
.85458 .00995 m
.85096 .01122 L
s
.86108 .01982 m
.85746 .02108 L
s
.86754 .02962 m
.86392 .03088 L
s
.87395 .03934 m
.87033 .0406 L
s
.88663 .05859 m
.883 .05983 L
s
.8929 .0681 m
.88927 .06934 L
s
.89912 .07755 m
.89549 .07878 L
s
.9053 .08693 m
.90167 .08816 L
s
.91753 .10548 m
.91389 .1067 L
s
.92358 .11466 m
.91994 .11588 L
s
.92958 .12378 m
.92594 .12499 L
s
.93554 .13283 m
.9319 .13403 L
s
.94734 .15073 m
.9437 .15193 L
s
.95318 .15959 m
.94953 .16078 L
s
.95898 .16839 m
.95533 .16958 L
s
.96473 .17713 m
.96108 .17831 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
.25 Mabswid
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
.18827 .43833 m
.02708 .28938 L
s
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.18827 .43833 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
0 0 m
1 0 L
1 .67912 L
0 .67912 L
closepath
clip
newpath
.5 Mabswid
.18026 .55551 m
.17307 .58675 L
s
.14421 .45186 m
.15335 .48199 L
s
.13079 .42362 m
.14421 .45186 L
s
.15335 .48199 m
.15761 .51151 L
s
.11403 .39971 m
.13079 .42362 L
s
.15761 .51151 m
.15676 .53803 L
s
.09521 .3824 m
.11403 .39971 L
s
.17307 .58675 m
.15955 .60872 L
s
.15676 .53803 m
.15096 .5594 L
s
.1323 .46386 m
.13843 .48534 L
s
.12305 .44355 m
.1323 .46386 L
s
.13843 .48534 m
.14103 .50617 L
s
.11133 .4262 m
.12305 .44355 L
s
.14103 .50617 m
.13996 .52463 L
s
.09808 .41346 m
.11133 .4262 L
s
.07584 .37356 m
.09521 .3824 L
s
.12349 .47176 m
.12757 .48703 L
s
.11713 .4572 m
.12349 .47176 L
s
.13996 .52463 m
.13539 .53919 L
s
.15096 .5594 m
.14077 .57387 L
s
.12757 .48703 m
.1291 .50167 L
s
.10898 .44463 m
.11713 .4572 L
s
.1291 .50167 m
.12802 .51447 L
s
.09967 .43526 m
.10898 .44463 L
s
.08438 .40668 m
.09808 .41346 L
s
.15955 .60872 m
.14086 .61954 L
s
.117 .47691 m
.11969 .48772 L
s
.11266 .46649 m
.117 .47691 L
s
.11969 .48772 m
.12056 .49799 L
s
.107 .45741 m
.11266 .46649 L
s
.12802 .51447 m
.12449 .52436 L
s
.13539 .53919 m
.1278 .54869 L
s
.12056 .49799 m
.11958 .50683 L
s
.10047 .45052 m
.107 .45741 L
s
.08998 .43006 m
.09967 .43526 L
s
.11226 .48022 m
.11402 .48786 L
s
.10931 .47278 m
.11226 .48022 L
s
.10539 .46623 m
.10931 .47278 L
s
.11402 .48786 m
.11448 .49503 L
s
.11958 .50683 m
.11688 .51354 L
s
.14077 .57387 m
.12711 .58025 L
s
.12449 .52436 m
.11887 .53056 L
s
.05762 .37452 m
.07584 .37356 L
s
.09363 .44653 m
.10047 .45052 L
s
.10082 .46117 m
.10539 .46623 L
s
.11448 .49503 m
.11364 .50114 L
s
.1088 .48232 m
.10995 .4877 L
s
.1068 .47702 m
.1088 .48232 L
s
.07143 .4068 m
.08438 .40668 L
s
.1041 .4723 m
.1068 .47702 L
s
.10995 .4877 m
.11017 .49271 L
s
.11364 .50114 m
.1116 .50566 L
s
.09599 .45813 m
.10082 .46117 L
s
.10091 .4686 m
.1041 .4723 L
s
.11688 .51354 m
.11276 .51756 L
s
.11017 .49271 m
.10947 .49691 L
s
.08077 .42969 m
.08998 .43006 L
s
.1278 .54869 m
.11788 .55235 L
s
.10629 .48363 m
.10703 .48742 L
s
.10494 .47986 m
.10629 .48363 L
s
.10308 .47647 m
.10494 .47986 L
s
.10703 .48742 m
.10711 .4909 L
s
.0975 .46629 m
.10091 .4686 L
s
.08708 .44594 m
.09363 .44653 L
s
.10085 .47376 m
.10308 .47647 L
s
.10947 .49691 m
.10794 .49996 L
s
.10711 .4909 m
.10654 .49379 L
s
.1116 .50566 m
.10858 .50826 L
s
.10448 .48443 m
.10495 .48709 L
s
.10357 .48175 m
.10448 .48443 L
s
.10229 .47932 m
.10357 .48175 L
s
.09133 .45746 m
.09599 .45813 L
s
.09846 .47201 m
.10085 .47376 L
s
.11887 .53056 m
.1117 .53259 L
s
.10495 .48709 m
.10495 .48951 L
s
.10074 .47734 m
.10229 .47932 L
s
.10654 .49379 m
.1054 .49583 L
s
.10495 .48951 m
.1045 .49149 L
s
.09419 .46563 m
.0975 .46629 L
s
.10317 .4849 m
.10346 .48677 L
s
.10256 .48301 m
.10317 .4849 L
s
.10168 .48126 m
.10256 .48301 L
s
.09905 .47603 m
.10074 .47734 L
s
.10794 .49996 m
.10574 .50162 L
s
.10346 .48677 m
.10343 .48845 L
s
.1006 .47983 m
.10168 .48126 L
s
.0961 .47142 m
.09846 .47201 L
s
.1045 .49149 m
.10365 .49286 L
s
.11276 .51756 m
.10759 .51861 L
s
.09942 .47884 m
.1006 .47983 L
s
.1054 .49583 m
.1038 .49688 L
s
.09738 .47552 m
.09905 .47603 L
s
.09823 .47842 m
.09942 .47884 L
s
.10365 .49286 m
.1025 .49351 L
s
.10858 .50826 m
.10487 .50874 L
s
.094 .47209 m
.0961 .47142 L
s
.09587 .47589 m
.09738 .47552 L
s
.10574 .50162 m
.10308 .50178 L
s
.09126 .46676 m
.09419 .46563 L
s
.09715 .47861 m
.09823 .47842 L
s
.08726 .45933 m
.09133 .45746 L
s
.1038 .49688 m
.1019 .49688 L
s
.1025 .49351 m
.10114 .49342 L
s
.08142 .44894 m
.08708 .44594 L
s
.09628 .47943 m
.09715 .47861 L
s
.09468 .47714 m
.09587 .47589 L
s
.07291 .43443 m
.08077 .42969 L
s
.10114 .49342 m
.09971 .49262 L
s
.09236 .47399 m
.094 .47209 L
s
.1019 .49688 m
.09988 .49585 L
s
.0957 .48082 m
.09628 .47943 L
s
.14086 .61954 m
.11866 .61822 L
s
.10308 .50178 m
.10021 .50048 L
s
.09971 .49262 m
.09834 .49119 L
s
.10487 .50874 m
.10082 .50713 L
s
.09391 .47919 m
.09468 .47714 L
s
.08902 .46964 m
.09126 .46676 L
s
.09549 .48266 m
.0957 .48082 L
s
.10759 .51861 m
.10188 .51668 L
s
.12711 .58025 m
.11124 .57803 L
s
.06048 .41417 m
.07143 .4068 L
s
.1117 .53259 m
.10366 .53036 L
s
.09988 .49585 m
.09791 .49391 L
s
.09834 .49119 m
.09714 .48929 L
s
.11788 .55235 m
.10656 .54996 L
s
.09566 .48482 m
.09549 .48266 L
s
.09135 .477 m
.09236 .47399 L
s
.09366 .48187 m
.09391 .47919 L
s
.09714 .48929 m
.09623 .4871 L
s
.09623 .4871 m
.09566 .48482 L
s
.08419 .46365 m
.08726 .45933 L
s
.10021 .50048 m
.0974 .49787 L
s
.09791 .49391 m
.09618 .49128 L
s
.09397 .48497 m
.09366 .48187 L
s
.09618 .49128 m
.09483 .4882 L
s
.09483 .4882 m
.09397 .48497 L
s
.08769 .47407 m
.08902 .46964 L
s
.09108 .48089 m
.09135 .477 L
s
.10082 .50713 m
.09681 .50363 L
s
.0974 .49787 m
.0949 .49423 L
s
.04232 .38582 m
.05762 .37452 L
s
.07724 .45542 m
.08142 .44894 L
s
.09161 .48532 m
.09108 .48089 L
s
.0949 .49423 m
.09291 .48991 L
s
.10188 .51668 m
.09615 .512 L
s
.09291 .48991 m
.09161 .48532 L
s
.08742 .4797 m
.08769 .47407 L
s
.08245 .47015 m
.08419 .46365 L
s
.09681 .50363 m
.09318 .4986 L
s
.10366 .53036 m
.09547 .52416 L
s
.0883 .48605 m
.08742 .4797 L
s
.06719 .4441 m
.07291 .43443 L
s
.09318 .4986 m
.09027 .49255 L
s
.09027 .49255 m
.0883 .48605 L
s
.09615 .512 m
.09091 .50508 L
s
.08225 .47829 m
.08245 .47015 L
s
.07497 .46493 m
.07724 .45542 L
s
.10656 .54996 m
.0949 .54182 L
s
.09091 .50508 m
.08663 .4966 L
s
.08367 .48738 m
.08225 .47829 L
s
.05266 .42853 m
.06048 .41417 L
s
.09547 .52416 m
.08791 .51465 L
s
.08663 .4966 m
.08367 .48738 L
s
.11124 .57803 m
.09462 .56749 L
s
.07492 .47671 m
.07497 .46493 L
s
.06426 .45801 m
.06719 .4441 L
s
.08791 .51465 m
.08163 .50278 L
s
.07719 .48972 m
.07492 .47671 L
s
.0949 .54182 m
.08396 .5288 L
s
.11866 .61822 m
.095 .60486 L
s
.08163 .50278 m
.07719 .48972 L
s
.03157 .40708 m
.04232 .38582 L
s
.06452 .47505 m
.06426 .45801 L
s
.04888 .44887 m
.05266 .42853 L
s
.08396 .5288 m
.07476 .5122 L
s
.09462 .56749 m
.07881 .54973 L
s
.0681 .49369 m
.06452 .47505 L
s
.07476 .5122 m
.0681 .49369 L
s
.04973 .47353 m
.04888 .44887 L
s
.07881 .54973 m
.0653 .52654 L
s
.095 .60486 m
.07213 .58076 L
s
.02671 .43683 m
.03157 .40708 L
s
.05533 .50027 m
.04973 .47353 L
s
.0653 .52654 m
.05533 .50027 L
s
.02858 .4726 m
.02671 .43683 L
s
.07213 .58076 m
.05226 .54838 L
s
.0373 .51105 m
.02858 .4726 L
s
.05226 .54838 m
.0373 .51105 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.875, 191.438},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000_b000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00i_ooool3
o`00033ooooo003Wooooo`03o`000?oooooooooo02oooooo003Oooooo`Go00000oooool00ol0003o
ooooooooo`0_ooooo`00ioooool00ol0003oooooooooo`0_ooooo`00ioooool00ol0003ooooooooo
o`0_ooooo`00i_ooool2o`00037ooooo003Jooooo`?o00002_ooool00ol0003oooooooooo`0_oooo
o`00]_ooool3o`0001oooooo0ol000000ooooooo0000ooooo`0kooooo`00]Oooool01Ol0003ooooo
oooooooooooo000001_ooooo0ol00004ooooo`;o0000>oooool00;Gooooo00Go0000oooooooooooo
ooooo`00000Hooooo`?o00001oooool00ol0003oooooo`00000jooooo`00]_ooool3o`0001Kooooo
0ol0000:ooooo`03o`000?oooooo000003[ooooo002eooooo`05o`000?ooooooooooooooool00000
4_ooool3o`0000;ooooo00?o0000ooooooooool02?ooool01?l0003oooooo`000?l0000iooooo`00
]Oooool01Ol0003ooooooooooooooooo0000013ooooo0_l0000@ooooo`05o`000?oooooooooooooo
ool00000>?ooool00;Kooooo0ol0000>ooooo`?o00004oooool00ol0003oooooooooo`02o`0000go
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000Looooo`00a?ooool3o`0001Kooooo
00?o0000ooooooooool00_l0000<ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooo
ooooooooo`00000Kooooo`00`Oooool3o`000003ooooool0003ooooo01Kooooo00Go0000oooooooo
ooooooooo`000005ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooo
oooo01Wooooo002nooooo`?o00007?ooool01?l0003oooooooooooooool2o`0000_ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`0Iooooo`00^oooool3o`0001oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo1?l0
000Looooo`00^?ooool3o`0002;ooooo00?o0000ooooooooool00oooool2o`0000Wooooo00Co0000
oooooooooooo00001oooool00ol0003oooooooooo`0Mooooo`00]_ooool3o`0002Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooo`00000:ooooo`;o00002?ooool5o`0001_ooooo002coooo
o`?o00000_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0<Oooool00;3ooooo0ol0000Zooooo`03o`000?oooooooooo00Gooooo0_l0000booooo`00
[Oooool3o`0002gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0`ooooo`00Z_oo
ool3o`00033ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0_ooooo`00Q_ooool3
o`0001kooooo0ol00002ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool01Oooool2
o`00037ooooo0025ooooo`05o`000?ooooooooooooooool000006oooool2o`0003Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`06ooooo`;o00009_ooool008Gooooo00Go0000oooo
ooooooooooooo`00000Hooooo`?o0000>Oooool00ol0003oooooooooo`07ooooo`;o00001_ooool0
1?l0003oooooooooool0000Uooooo`00QOooool4o`0001Kooooo0ol0000looooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000Uooooo`00QOooool0
0ol0003oooooooooo`0Dooooo`?o000000?oooooo`000?ooool0??ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00009Oooool008Kooooo00?o0000
ooooooooool04?ooool3o`0004;ooooo00?o0000ooooooooool02Oooool2o`0000Cooooo00Co0000
oooooooooooo00009Oooool008Oooooo0_l0000=ooooo`?o0000AOooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00009Oooool009Cooooo0_l00018
ooooo`03o`000?oooooooooo00Wooooo0ol00004ooooo`;o00009_ooool0097ooooo1?l00019oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0:_ooool008kooooo0ol0001=ooooo`03
o`000?oooooooooo00cooooo0_l0000Zooooo`00Roooool3o`00053ooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`0Xooooo`00R?ooool3o`0005Cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Xooooo`00QOooool4o`0005Kooooo00?o0000ooooooooool03?ooool2
o`0002Wooooo0023ooooo`;o00000oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool01_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`00
01;ooooo0020ooooo`?o0000G?ooool00ol0003oooooooooo`0>ooooo`;o00001_ooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000004Oooool007gooooo0ol0001Ooooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00oooooo001Jooooo`?o00007Oooool4o`00067ooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000
ooooooooool03oooool005_ooooo00?o0000ooooooooool06Oooool3o`0006Gooooo00?o0000oooo
ooooool03oooool2o`0000Gooooo00Co0000oooooooooooo00001oooool4o`0001;ooooo001Hoooo
o`Go00005oooool3o`0006Sooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool04oooool005Sooooo00Co0000oooo
oooooooo00005Oooool3o`0006_ooooo00?o0000ooooooooool04?ooool3o`0000Cooooo0_l00008
ooooo`Go00004Oooool005Wooooo00?o0000ooooool000004oooool3o`0006gooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Rooooo`00F_ooool2o`00013ooooo0ol0001`ooooo`03
o`000?oooooooooo01;ooooo0_l0000Sooooo`00Foooool00ol0003oooooooooo`0;ooooo`?o0000
Loooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo023ooooo001Vooooo`?o0000Mooo
ool00ol0003oooooooooo`0Cooooo`;o00008Oooool006?ooooo1?l0001iooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool07oooool0063ooooo0ol0001mooooo`03o`000?oooooooooo
01Cooooo0_l00007ooooo`?o00000oooool3o`00013ooooo001Nooooo`;o0000P?ooool00ol0003o
ooooooooo`0Dooooo`;o00002?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oo
oooo001Kooooo`?o0000P_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00?ooooo
1Ol00003ooooo`03o`000?oooooooooo00oooooo001Hooooo`Co0000Q?ooool00ol0003ooooooooo
o`0Fooooo`;o00001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001E
ooooo`?o00000oooool00ol0003oooooooooo`22ooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001Boooo
o`?o0000Roooool00ol0003oooooooooo`0Fooooo`?o00001?ooool2o`0000Cooooo0_l0000Aoooo
o`00;Oooool5o`0001gooooo0ol0002>ooooo`03o`000?oooooooooo01?ooooo0ol00002ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0?ooooo`00
;_ooool01?l0003oooooooooool0000Kooooo`;o000000?oooooo`000?ooool0S_ooool00ol0003o
ooooooooo`0@ooooo`?o00001Oooool00ol0003oooooooooo`0Kooooo`00;oooool00ol0003ooooo
ooooo`0Hooooo`?o0000Toooool00ol0003oooooooooo`0=ooooo`?o00002?ooool2o`0001cooooo
000`ooooo`03o`000?oooooooooo01Cooooo0ol0002Gooooo`03o`000?oooooooooo00Wooooo0ol0
000;ooooo`03o`000?oooooooooo01_ooooo000]ooooo`05o`000?ooooooooooooooool000004_oo
ool3o`0009[ooooo00?o0000ooooooooool01_ooool3o`0000oooooo00?o0000ooooooooool06_oo
ool002gooooo00Go0000ooooooooooooooooo`00000?ooooo`?o000000?oooooo`000?ooool0V_oo
ool00ol0003oooooooooo`03ooooo`?o00004_ooool00ol0003oooooooooo`0Jooooo`00;_ooool3
o`0000gooooo0ol0002Pooooo`03o`000?oooooooooo00?o00005?ooool2o`0001cooooo000loooo
o`;o0000Xoooool3o`0001Sooooo00?o0000ooooooooool06_ooool003Wooooo0ol0002Rooooo`Co
00006_ooool00ol0003oooooooooo`0Jooooo`00=_ooool3o`000003ooooool0003ooooo09oooooo
0ol00003ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool06_ooool003?ooooo0ol0
002Rooooo`?o00001_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Wooooo0_l0
0004ooooo`03o`000?oooooooooo00;ooooo0ol00003ooooo`00<?ooool3o`000:;ooooo0ol00009
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool0
0007ooooo`05o`000?ooooooooooooooool000000_ooool002gooooo1?l0002Pooooo`Co00003?oo
ool00ol0003oooooooooo`0Hooooo`;o00000_ooool5o`0000;ooooo00Co0000oooooooooooo0000
2oooool1o`00007ooooo0Oooool002[ooooo0ol00003ooooo`03o`000?oooooooooo09_ooooo0ol0
000@ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool01oooool01?l0003ooooooooo
ool0000;ooooo`7o00000Oooool1ooooo`00:?ooool2o`000:7ooooo0ol0000Dooooo`03o`000?oo
oooooooo01Sooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00007ooooo`Co0000
0oooool000Kooooo0_l0000Mooooo`?o0000X?ooool3o`0001Oooooo00?o0000ooooooooool05ooo
ool2o`0000Wooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`04ooooo`001Ooo
ool01?l0003oooooooooool0000Iooooo`Co0000Woooool3o`0001[ooooo00?o0000ooooooooool0
6?ooool00ol0003oooooooooo`08ooooo`;o00002?ooool5o`0000;ooooo0005ooooo`04o`000?oo
ooooooooo`0001Kooooo0ol0002Pooooo`?o00007Oooool00ol0003oooooooooo`0Hooooo`03o`00
0?oooooooooo01Wooooo0005ooooo`04o`000?ooooooooooo`0001?ooooo0ol0002Pooooo`?o0000
8?ooool00ol0003oooooooooo`0Hooooo`;o00006_ooool000Gooooo00Co0000oooooooooooo0000
4?ooool3o`000:3ooooo0ol0000Qooooo`?o00006_ooool00ol0003oooooooooo`0Iooooo`001Ooo
ool01?l0003oooooooooool0000>ooooo`;o00000_ooool00ol0003oooooooooo`2Kooooo`?o0000
8Oooool3o`0000;ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Iooooo`001_oo
ool2o`0000cooooo0ol0002Oooooo`?o00008Oooool3o`0000Kooooo00?o0000ooooooooool05ooo
ool2o`0001[ooooo000Aooooo`?o0000Woooool3o`00027ooooo0ol0000:ooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool06?ooool000kooooo1?l0002Nooooo`?o00008Oooool3o`00
00kooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Hooooo`002oooool3o`0009oo
oooo0ol0000Pooooo`Co00004Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo01So
oooo0008ooooo`?o0000W_ooool4o`00023ooooo0ol0000Fooooo`03o`000?oooooooooo01Cooooo
0_l0000Jooooo`001oooool2o`0009gooooo0ol0000Qooooo`?o00006_ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo00?ooooo0_l0000Cooooo`001oooool00ol0003oooooo`00002I
ooooo`?o00008Oooool3o`0001gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0001;ooooo0006ooooo`;o00000_ooool00ol0003oooooooooo`2C
ooooo`?o00008Oooool3o`00027ooooo00?o0000ooooooooool04oooool2o`0000?ooooo00Co0000
oooooooooooo00004_ooool000Oooooo00Go0000ooooooooooooooooo`00002Aooooo`?o00008Ooo
ool3o`0002Gooooo00?o0000ooooooooool04oooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooooooool04?ooool000Oooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`2;ooooo`?o00008?ooool4o`0002Wooooo00?o0000ooooooooool04_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00?o0000ooooooooool04?ooool000Oooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`27ooooo`?o00008?ooool3o`0002gooooo00?o0000ooooooooool04Ooo
ool2o`0000?ooooo00Co0000oooooooooooo00004_ooool000Kooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`23ooooo`?o00008?ooool3o`00037ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`02ooooo`;o00004oooool000Kooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`1oooooo`?o00008?ooool3o`0003Gooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Gooooo`001_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
07_ooooo0ol0000Pooooo`?o0000>?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
01Oooooo0006ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0Moooool3o`0001oo
oooo1?l0000looooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool05oooool000Kooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`1cooooo`?o00007oooool3o`00047ooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Gooooo`001_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo06oooooo0ol0000Oooooo`?o0000AOooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo01Kooooo0006ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool0Joooool3o`0001oooooo0ol00018ooooo`03o`000?oooooooooo00gooooo0_l0000H
ooooo`001_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo06Kooooo1?l0000Ooooo
o`?o0000C?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Kooooo0006ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool0H_ooool3o`00023ooooo0ol0001@ooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool05_ooool000Gooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`1Nooooo`?o00007oooool4o`0005?ooooo00?o0000ooooooooool0
2oooool2o`0001Sooooo0005ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0F_oo
ool3o`0001oooooo0ol0001Hooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool05_oo
ool000Gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1Fooooo`?o00007oooool3
o`0005cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`;o00001?ooool0
0ol0003oooooooooo`02ooooo`?o00001Oooool000Gooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`1Booooo`?o00007oooool3o`00063ooooo00?o0000ooooooooool02Oooool2o`00
00?ooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo0005
ooooo`03o`000?oooooooooo01?ooooo0_l0001?ooooo`?o00007oooool3o`0006?ooooo00?o0000
ooooooooool02Oooool2o`0000?ooooo00Co0000oooooooooooo00002oooool00ol0003ooooooooo
o`02ooooo`001Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo04Wooooo0ol0000N
ooooo`Co0000Ioooool00ol0003oooooooooo`09ooooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00;ooooo0005ooooo`03o`000?oooooo
oooo01Kooooo00?o0000ooooooooool0AOooool3o`0001kooooo0ol0001/ooooo`03o`000?oooooo
oooo00Sooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Gooooo1?l0
0005ooooo`001Oooool00ol0003oooooooooo`05ooooo`So00002_ooool00ol0003oooooooooo`11
ooooo`?o00007_ooool3o`0006oooooo00?o0000ooooooooool01_ooool3o`0000?ooooo00Co0000
oooooooooooo00001oooool00ol0003oooooooooo`06ooooo`001Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00Kooooo0ol00008ooooo`03o`000?oooooooooo03gooooo0ol0000N
ooooo`?o0000Loooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo0_l00008
ooooo`Go00001?ooool000Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0:oooo
o`;o00001oooool00ol0003oooooooooo`0iooooo`?o00007_ooool3o`0007Oooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0Eooooo`001?ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0eooooo`?o
00007_ooool3o`0007_ooooo00?o0000ooooooooool01?ooool2o`0001Oooooo0004ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo033ooooo1?l0000Mooooo`Co0000O_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo01Gooooo0004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02cooooo0ol0000Nooooo`?o0000Pooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Gooooo0004ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo02Sooooo0ol0000Nooooo`?o0000Qoooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo01Cooooo0004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo02Cooooo0ol0000Nooooo`?o0000R_ooool00ol0
003oooooooooo`03ooooo`;o00005_ooool000Cooooo00Go0000ooooooooooooooooo`000008oooo
o`Ko00001oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo023ooooo0ol0000Noooo
o`?o0000S_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Cooooo0004ooooo`05
o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`04ooooo`;o00001Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo01cooooo0ol0000Mooooo`Co0000T_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo01Cooooo0004ooooo`05o`000?oooooooooooooo
ool000001_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Hooooo`?o00007Oooool3o`0009Oooooo00?o0000oooo
ooooool00_l0000Fooooo`000oooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool05?ooool3o`0001gooooo0ol0002Jooooo`05o`000?ooooooooooooooool000005_ooool0
00?ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo013ooooo0ol0000M
ooooo`?o0000W_ooool01?l0003oooooooooool00004ooooo`?o00003oooool000?ooooo00Go0000
ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00cooooo0ol0000Mooooo`?o0000X_oo
ool01?l0003oooooo`000?l00004ooooo`03o`000?oooooooooo00kooooo0003ooooo`05o`000?oo
ooooooooooooool000001Oooool00ol0003oooooooooo`03ooooo`Go00001?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool3o`0001gooooo
0ol0002Uooooo`04o`000?oooooo0000o`0000Cooooo00?o0000ooooooooool03_ooool000?ooooo
00Co0000oooooooooooo00001_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool01?ooool3o`0001cooooo1?l0002Yooooo`03o`000?oooooo000000Co
oooo00?o0000ooooooooool03_ooool000?ooooo00Co0000oooooooooooo00001_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00Cooooo0_l00003ooooo`05o`000?oooooooooooooo
ool000003?ooool00ol0003oooooooooo`03o`0001cooooo0ol0002^ooooo`;o00001?ooool00ol0
003oooooooooo`0>ooooo`000oooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00004ooooo`03o`000?oooooo
oooo00[ooooo0_l0000Looooo`?o0000/?ooool3o`0000?ooooo0_l0000@ooooo`000oooool01?l0
003oooooooooool00005ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool2
o`0000Cooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo01Sooooo0ol0002`ooooo`?o00001oooool00ol0003oooooooooo`0>ooooo`000oooool0
1?l0003oooooooooool00005ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooooooo
o`000002ooooo`;o00000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool05Oooool3o`000:oooooo1?l0000Kooooo`000_ooool01Ol0003ooooo
oooooooooooo000000Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo0000
00Cooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool04Oooool4o`000:oooooo0ol0000Oooooo`000_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000003
ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooo
oooooooooooo000000[ooooo00?o0000ooooooooool03_ooool3o`000:oooooo1?l0000Rooooo`00
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooo
ooooo`000003ooooo`04o`000?oooooo0000ooooo`Co00000_ooool01?l0003oooooooooool00003
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02oooool3o`000:oooooo0ol0000V
ooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooo000000Cooooo00?o0000ooooool000000_ooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool3o`000:kooooo1?l0000Yooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo0000ooooo`Go0000
00Coooooo`000?oooooo00000_ooool01Ol0003ooooooooooooooooo000000Wooooo00?o0000oooo
ooooool01Oooool3o`000:kooooo0ol0000]ooooo`000_ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo0000
ooooo`?o000000Coooooo`000?l0003o00000_ooool00ol0003oooooo`000003ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool00_ooool3o`000:kooooo0ol0000`ooooo`000_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooo000000Oo000000Koooooo`000?oooooo0000ooooool00003ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooool000000ol0002]ooooo`Co0000<oooool000;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool0
00000_ooool00ol0003oooooo`000006o`000005ooooool0003o0000ooooool000000_ooool01Ol0
003ooooooooooooooooo000000Kooooo0ol0002^ooooo`?o0000=oooool000;ooooo00?o0000oooo
ooooool00oooool01Ol0003ooooooooooooooooo000000?ooooo00Go0000oooooooooooo0000oooo
o`04o`000003ooooool0003o000000?o00000_ooool00ol0003oooooo`000003ooooo`04o`000?oo
ooooooooooooo`?o000000?oooooo`000?ooool0Z_ooool4o`0003[ooooo00000ooooooo0000oooo
o`05ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`Go0000
00?oooooo`000?l000000_l000001_oooooo0000ooooool0003oooooo`0000?ooooo1?l00004oooo
o`03o`000?oooooooooo0:Kooooo0ol0000nooooo`0000?oooooo`000?ooool01Oooool00ol0003o
ooooooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool3o`000003ooooool0003o0000
00Co000000Ooooooo`000?oooooo0000ooooool0003ooooo00?o00001oooool00ol0003ooooooooo
o`2Rooooo`Co0000@Oooool00003ooooool0003ooooo00Gooooo00?o0000ooooooooool00_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000001ol000000ooooooo0000oooo
o`04o`0000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2Oooooo`?o0000AOoo
ool00003ooooool0003ooooo00Gooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0
0003ooooo`;o000000Goooooo`000?l0003o0000ooooo`06o`0000;ooooo00Co0000oooooooooooo
00001oooool00ol0003oooooooooo`2Kooooo`Co0000B?ooool00003ooooool0003ooooo00Kooooo
00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo0_l00002ooooo`Go
000000Coooooo`000?oooooo00000_ooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000
ooooooooool0V?ooool3o`0004cooooo00000ooooooo0000ooooo`06ooooo`03o`000?oooooooooo
00;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000?o000000Oooooo
o`000?ooooooooooo`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000006ooooo`03
o`000?oooooooooo09Cooooo1?l0001?ooooo`0000?oooooo`000?ooool01_ooool00ol0003ooooo
ooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo0ol00003ooooo`;o00000_ooool00ol0003o
ooooo`000002ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`2Aoooo
o`?o0000Doooool00003ooooool0003ooooo00Kooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`03o`000003ooooool0003ooooo00;o00001?ooool01?l0003oooooooooool00002oooo
o`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`2=ooooo`Co0000E_ooool0
0003ooooool0003ooooo00Oooooo00Co0000oooooooooooooooo1?l000001Ooooooo0000oooooooo
oooo000000?ooooo1?l00003ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`2:ooooo`?o0000F_ooool00003o`000?oooooooooo00Oooooo1?l0
0002ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`06ooooo`05o`00
0?ooooooooooooooool000000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo08Ko
oooo1?l0001Mooooo`0000?o0000ooooooooool01Oooool3o`0000Gooooo00Go0000oooooooooooo
ooooo`000003ooooo`;o00001Oooool2o`0000?ooooo00Go0000ooooooooooooooooo`000006oooo
o`03o`000?oooooooooo08?ooooo0ol0001Qooooo`0000?o0000ooooooooool00_ooool3o`0000?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
oooo0_l000000ooooooo0000o`000005ooooo`05o`000?ooooooooooooooool000001_ooool00ol0
003oooooooooo`20ooooo`?o0000I?ooool00003o`000?oooooo000000;o00001_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`05ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`1moooo
o`Co0000Ioooool000;o00002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0N_ooool3o`0006_ooooo0002ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`;o00002Oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0M_ooool4o`0006kooooo
0003ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo07?ooooo0ol0001booooo`001?ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool3o`0000;ooooo0_l00006
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Koooool4o`0007Gooooo0005oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`07oooo
o`;o00001oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo06cooooo0ol0001ioooo
o`001_ooool2o`0000Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0J?ooool4o`0007cooooo0008ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0IOooool3o`00083ooooo0009ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0HOooool4o`0008?ooooo000:ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool01Oooool2o`0000cooooo00?o0000ooooooooool01?ooool2
o`00063ooooo0ol00027ooooo`002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`;o0000G?ooool4o`00
08[ooooo000<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`04ooooo`?o00002?ooool2o`0005Wooooo0ol0002>ooooo`003Oooool2o`0000?ooooo
00?o0000ooooooooool01oooool6o`0000_ooooo0_l0001Eooooo`Co0000TOooool000oooooo00Co
0000oooooooooooo00006Oooool00ol0003oooooo`00001Booooo`?o0000UOooool0013ooooo00Co
0000oooooooooooo00006?ooool00ol0003oooooo`00001>ooooo`Co0000V?ooool0017ooooo00Co
0000oooooooooooo00005oooool00ol0003oooooo`00001;ooooo`?o0000W?ooool001;ooooo00Co
0000oooooooooooo00005Oooool00ol0003oooooo`000019ooooo`?o0000Woooool001?ooooo0_l0
00000ooooooo0000ooooo`0Cooooo`03o`000?oooooo000004Gooooo1?l0002Rooooo`005Oooool0
0ol0003oooooo`00000Booooo`04o`000?ooooooooooo`0004;ooooo0ol0002Vooooo`005_ooool0
1?l0003oooooo`000?l0000@ooooo`04o`000?ooooooooooo`0003kooooo1?l0002Yooooo`005ooo
ool00ol0003oooooooooo`02o`0000cooooo0_l00003ooooo`03o`000?oooooooooo03Wooooo0ol0
002]ooooo`006?ooool01?l0003oooooooooooooool2o`0000Sooooo0_l00005ooooo`03o`000?oo
oooooooo03Gooooo1?l0002`ooooo`006Oooool2o`0000?ooooo1?l00003ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0<_ooool3o`000;Cooooo000Kooooo`03o`000?oooooooooo
00Cooooo0ol00008ooooo`03o`000?oooooooooo02kooooo1?l0002gooooo`007?ooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo02_ooooo0ol0002kooooo`007Oooool00ol0003ooooo
ooooo`0=ooooo`03o`000?oooooooooo02Oooooo1?l0002nooooo`007_ooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo02Cooooo0ol00032ooooo`007oooool2o`0000cooooo00?o0000
ooooooooool08?ooool4o`000<Gooooo000Qooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool07Oooool3o`000<Wooooo000Rooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool06Oooool4o`000<cooooo000Sooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
5_ooool3o`000=3ooooo000Tooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05?oo
ool3o`000=?ooooo000Uooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04?ooool4
o`000=Kooooo000Vooooo`;o00001?ooool00ol0003oooooooooo`0=ooooo`?o0000f_ooool002So
oooo00Go0000ooooooooooooooooo`00000;ooooo`Co0000gOooool002Wooooo00Co0000oooooooo
oooo00002?ooool3o`000>7ooooo000Zooooo`03o`000?oooooo000000Cooooo1?l0003Tooooo`00
:oooool2o`000004ooooool0003o0000o`000>Sooooo000/ooooo`;o0000joooool00?oooooo6_oo
ool00?oooooo6_ooool00?oooooo6_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.875}, {190.438, 0}} -> {0.0219893, 0.106871, \
0.00376814, 0.00376814}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Depict The two Solutions"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["The First Solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p2 = 
        ParametricPlot3D[{t, E\^\(-\(t\/3\)\)\ Cos[6\ t], \(-1\)}, {t, 0, 
            3\ \[Pi],  .05}, Boxed \[Rule] True, 
          PlotRange \[Rule] {{0, 3\ \[Pi]}, {\(-1\), 1}, {\(-1\), 1}}, 
          BoxRatios \[Rule] {3, 1, 1}];\)\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .67912 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0224888 1.02249 -0.150431 1.02249 [
[.02846 .27668 -2.67377 -9 ]
[.02846 .27668 3.32623 0 ]
[.18704 .22058 -2.78329 -9 ]
[.18704 .22058 3.21671 0 ]
[.35321 .1618 -2.90126 -9 ]
[.35321 .1618 3.09874 0 ]
[.52756 .10014 -3.0287 -9 ]
[.52756 .10014 2.9713 0 ]
[.71068 .0354 -3.1668 -9 ]
[.71068 .0354 2.8332 0 ]
[.86008 -0.00425 0 -6.08625 ]
[.86008 -0.00425 12 2.91375 ]
[.8924 .04484 0 -6.05064 ]
[.8924 .04484 24 2.94936 ]
[.92355 .09216 0 -6.0166 ]
[.92355 .09216 6 2.9834 ]
[.9536 .13781 0 -5.98402 ]
[.9536 .13781 18 3.01598 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 6 3.04719 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 12 3.04719 ]
[.9897 .2427 0 -5.91612 ]
[.9897 .2427 24 3.08388 ]
[.99701 .30533 0 -5.87841 ]
[.99701 .30533 6 3.12159 ]
[1.00453 .36986 0 -5.83963 ]
[1.00453 .36986 18 3.16037 ]
[1.01228 .43637 0 -5.79975 ]
[1.01228 .43637 6 3.20025 ]
[ 0 0 0 0 ]
[ 1 .67912 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.84803 0 m
.842 .00212 L
s
[(-1)] .86008 -0.00425 -1 .3525 Mshowa
.88031 .049 m
.87427 .05108 L
s
[(-0.5)] .8924 .04484 -1 .34459 Mshowa
.91144 .09624 m
.90538 .09828 L
s
[(0)] .92355 .09216 -1 .33702 Mshowa
.94146 .14181 m
.93539 .14381 L
s
[(0.5)] .9536 .13781 -1 .32978 Mshowa
.97045 .1858 m
.96437 .18777 L
s
[(1)] .98261 .18188 -1 .32285 Mshowa
.125 Mabswid
.85458 .00995 m
.85096 .01122 L
s
.86108 .01982 m
.85746 .02108 L
s
.86754 .02962 m
.86392 .03088 L
s
.87395 .03934 m
.87033 .0406 L
s
.88663 .05859 m
.883 .05983 L
s
.8929 .0681 m
.88927 .06934 L
s
.89912 .07755 m
.89549 .07878 L
s
.9053 .08693 m
.90167 .08816 L
s
.91753 .10548 m
.91389 .1067 L
s
.92358 .11466 m
.91994 .11588 L
s
.92958 .12378 m
.92594 .12499 L
s
.93554 .13283 m
.9319 .13403 L
s
.94734 .15073 m
.9437 .15193 L
s
.95318 .15959 m
.94953 .16078 L
s
.95898 .16839 m
.95533 .16958 L
s
.96473 .17713 m
.96108 .17831 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
.25 Mabswid
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
.18827 .43833 m
.02708 .28938 L
s
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.18827 .43833 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
0 0 m
1 0 L
1 .67912 L
0 .67912 L
closepath
clip
newpath
.5 Mabswid
.18827 .43833 m
.18742 .43287 L
s
.18742 .43287 m
.18038 .42164 L
s
.18038 .42164 m
.16817 .40556 L
s
.16817 .40556 m
.15224 .38595 L
s
.24073 .39161 m
.24557 .39132 L
s
.23107 .38727 m
.24073 .39161 L
s
.24557 .39132 m
.24569 .38644 L
s
.21686 .37859 m
.23107 .38727 L
s
.24569 .38644 m
.24154 .3774 L
s
.15224 .38595 m
.13431 .36439 L
s
.1988 .36625 m
.21686 .37859 L
s
.24154 .3774 m
.2339 .36493 L
s
.17793 .35128 m
.1988 .36625 L
s
.2339 .36493 m
.22385 .35006 L
s
.13431 .36439 m
.11634 .3427 L
s
.15563 .33501 m
.17793 .35128 L
s
.22385 .35006 m
.21263 .33398 L
s
.30759 .34988 m
.31186 .3489 L
s
.29994 .34746 m
.30759 .34988 L
s
.31186 .3489 m
.31286 .34459 L
s
.28911 .34185 m
.29994 .34746 L
s
.31286 .34459 m
.31094 .33729 L
s
.11634 .3427 m
.10029 .32272 L
s
.27554 .33352 m
.28911 .34185 L
s
.31094 .33729 m
.3067 .32759 L
s
.13354 .31901 m
.15563 .33501 L
s
.21263 .33398 m
.20162 .31802 L
s
.25998 .32322 m
.27554 .33352 L
s
.3067 .32759 m
.3009 .31625 L
s
.24336 .31193 m
.25998 .32322 L
s
.10029 .32272 m
.08799 .30617 L
s
.11338 .30491 m
.13354 .31901 L
s
.20162 .31802 m
.19214 .30351 L
s
.3009 .31625 m
.29443 .30418 L
s
.22681 .30074 m
.24336 .31193 L
s
.38117 .3111 m
.38519 .30971 L
s
.3748 .31001 m
.38117 .3111 L
s
.3662 .30656 m
.3748 .31001 L
s
.38519 .30971 m
.38697 .30591 L
s
.35568 .30111 m
.3662 .30656 L
s
.08799 .30617 m
.08089 .29446 L
s
.38697 .30591 m
.38676 .29998 L
s
.09685 .29431 m
.11338 .30491 L
s
.29443 .30418 m
.28825 .29235 L
s
.19214 .30351 m
.18541 .29163 L
s
.34373 .29418 m
.35568 .30111 L
s
.2115 .29084 m
.22681 .30074 L
s
.38676 .29998 m
.38501 .29237 L
s
.08089 .29446 m
.07992 .28848 L
s
.08537 .28854 m
.09685 .29431 L
s
.331 .28646 m
.34373 .29418 L
s
.38501 .29237 m
.38226 .28365 L
s
.28825 .29235 m
.28326 .28168 L
s
.18541 .29163 m
.18234 .28331 L
s
.19857 .28336 m
.2115 .29084 L
s
.07992 .28848 m
.08537 .28854 L
s
.31825 .27876 m
.331 .28646 L
s
.38226 .28365 m
.37915 .2745 L
s
.18901 .27923 m
.19857 .28336 L
s
.18234 .28331 m
.1835 .27913 L
s
.28326 .28168 m
.28025 .27302 L
s
.1835 .27913 m
.18901 .27923 L
s
.30629 .27191 m
.31825 .27876 L
s
.37915 .2745 m
.37633 .26561 L
s
.46021 .27432 m
.46418 .2727 L
s
.45463 .27413 m
.46021 .27432 L
s
.44749 .27222 m
.45463 .27413 L
s
.28025 .27302 m
.27982 .26697 L
s
.46418 .2727 m
.4666 .26934 L
s
.439 .26882 m
.44749 .27222 L
s
.29589 .26674 m
.30629 .27191 L
s
.4666 .26934 m
.4677 .26447 L
s
.42949 .26431 m
.439 .26882 L
s
.27982 .26697 m
.2823 .26391 L
s
.28773 .2639 m
.29589 .26674 L
s
.37633 .26561 m
.37441 .25766 L
s
.4677 .26447 m
.46777 .25842 L
s
.41941 .25918 m
.42949 .26431 L
s
.2823 .26391 m
.28773 .2639 L
s
.40926 .25401 m
.41941 .25918 L
s
.46777 .25842 m
.46722 .25163 L
s
.37441 .25766 m
.37391 .2512 L
s
.3996 .2494 m
.40926 .25401 L
s
.46722 .25163 m
.46648 .24459 L
s
.37391 .2512 m
.37521 .24667 L
s
.39097 .24594 m
.3996 .2494 L
s
.37521 .24667 m
.37851 .24431 L
s
.38382 .24412 m
.39097 .24594 L
s
.46648 .24459 m
.46599 .2378 L
s
.37851 .24431 m
.38382 .24412 L
s
.53868 .23924 m
.54381 .23881 L
s
.53248 .23841 m
.53868 .23924 L
s
.54381 .23881 m
.54783 .23707 L
s
.52532 .23647 m
.53248 .23841 L
s
.46599 .2378 m
.46618 .23175 L
s
.54783 .23707 m
.5508 .23408 L
s
.51745 .2337 m
.52532 .23647 L
s
.5508 .23408 m
.55289 .23001 L
s
.50915 .23045 m
.51745 .2337 L
s
.46618 .23175 m
.46738 .22682 L
s
.50077 .22712 m
.50915 .23045 L
s
.55289 .23001 m
.5543 .22512 L
s
.49269 .22416 m
.50077 .22712 L
s
.46738 .22682 m
.46983 .22331 L
s
.5543 .22512 m
.55532 .21974 L
s
.48528 .22199 m
.49269 .22416 L
s
.46983 .22331 m
.47366 .22135 L
s
.47885 .22096 m
.48528 .22199 L
s
.47366 .22135 m
.47885 .22096 L
s
.55532 .21974 m
.55625 .21422 L
s
.55625 .21422 m
.5574 .20893 L
s
.5574 .20893 m
.55905 .20421 L
s
.62645 .20488 m
.63134 .20402 L
s
.62082 .2048 m
.62645 .20488 L
s
.61453 .20391 m
.62082 .2048 L
s
.55905 .20421 m
.56141 .20033 L
s
.63134 .20402 m
.63548 .20222 L
s
.60773 .2024 m
.61453 .20391 L
s
.60062 .2005 m
.60773 .2024 L
s
.63548 .20222 m
.6389 .19952 L
s
.59343 .19853 m
.60062 .2005 L
s
.56141 .20033 m
.56464 .19748 L
s
.6389 .19952 m
.64174 .19606 L
s
.58642 .19678 m
.59343 .19853 L
s
.56464 .19748 m
.56881 .19577 L
s
.57984 .19557 m
.58642 .19678 L
s
.64174 .19606 m
.64414 .19203 L
s
.56881 .19577 m
.57391 .19517 L
s
.57391 .19517 m
.57984 .19557 L
s
.64414 .19203 m
.6463 .18767 L
s
.6463 .18767 m
.64842 .18324 L
s
.64842 .18324 m
.65072 .17902 L
s
.65072 .17902 m
.65338 .17522 L
s
.65338 .17522 m
.65655 .17205 L
s
.65655 .17205 m
.66032 .16964 L
s
.71231 .17114 m
.7176 .17067 L
s
.70656 .171 m
.71231 .17114 L
s
.70044 .17039 m
.70656 .171 L
s
.7176 .17067 m
.72239 .16953 L
s
.6941 .16949 m
.70044 .17039 L
s
.66032 .16964 m
.66473 .16805 L
s
.72239 .16953 m
.72667 .1677 L
s
.68769 .1685 m
.6941 .16949 L
s
.68139 .16765 m
.68769 .1685 L
s
.66473 .16805 m
.66977 .16726 L
s
.72667 .1677 m
.73047 .16523 L
s
.67537 .16718 m
.68139 .16765 L
s
.66977 .16726 m
.67537 .16718 L
s
.73047 .16523 m
.73389 .16222 L
s
.73389 .16222 m
.73702 .15882 L
s
.73702 .15882 m
.74001 .1552 L
s
.74001 .1552 m
.74299 .15155 L
s
.74299 .15155 m
.74612 .14807 L
s
.74612 .14807 m
.7495 .14492 L
s
.7495 .14492 m
.75323 .14223 L
s
.75323 .14223 m
.75739 .1401 L
s
.75739 .1401 m
.76198 .13856 L
s
.76198 .13856 m
.767 .13759 L
s
.79566 .13766 m
.80135 .13761 L
s
.78981 .13748 m
.79566 .13766 L
s
.80135 .13761 m
.80679 .13721 L
s
.767 .13759 m
.77238 .13712 L
s
.7839 .13722 m
.78981 .13748 L
s
.77805 .13705 m
.7839 .13722 L
s
.80679 .13721 m
.81191 .13636 L
s
.77238 .13712 m
.77805 .13705 L
s
.81191 .13636 m
.81669 .13502 L
s
.81669 .13502 m
.82112 .13318 L
s
.82112 .13318 m
.82524 .13089 L
s
.82524 .13089 m
.82911 .12821 L
s
.82911 .12821 m
.8328 .12526 L
s
.8328 .12526 m
.8364 .12216 L
s
.8364 .12216 m
.84001 .11907 L
s
.84001 .11907 m
.84373 .11611 L
s
.84373 .11611 m
.84764 .11339 L
s
.84764 .11339 m
.85179 .11103 L
s
.85179 .11103 m
.85623 .10907 L
s
.85623 .10907 m
.86097 .10753 L
s
.86097 .10753 m
.866 .10641 L
s
.866 .10641 m
.87127 .10564 L
s
.87127 .10564 m
.87673 .10514 L
s
.87673 .10514 m
.8823 .10481 L
s
.8823 .10481 m
.88791 .10452 L
s
.88791 .10452 m
.89347 .10417 L
s
.89347 .10417 m
.89892 .10364 L
s
.89892 .10364 m
.90419 .10285 L
s
.90419 .10285 m
.90925 .10173 L
s
.90925 .10173 m
.91407 .10024 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.875, 191.438},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000_b000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00i_ooool3
o`00033ooooo003Wooooo`03o`000?oooooooooo02oooooo003Oooooo`Go00000oooool00ol0003o
ooooooooo`0_ooooo`00ioooool00ol0003oooooooooo`0_ooooo`00ioooool00ol0003ooooooooo
o`0_ooooo`00i_ooool2o`00037ooooo003Jooooo`?o00002_ooool00ol0003oooooooooo`0_oooo
o`00]_ooool3o`0001oooooo0ol000000ooooooo0000ooooo`0kooooo`00]Oooool01Ol0003ooooo
oooooooooooo000001_ooooo0ol00004ooooo`;o0000>oooool00;Gooooo00Go0000oooooooooooo
ooooo`00000Hooooo`?o00001oooool00ol0003oooooo`00000jooooo`00]_ooool3o`0001Kooooo
0ol0000:ooooo`03o`000?oooooo000003[ooooo002eooooo`05o`000?ooooooooooooooool00000
4_ooool3o`0000;ooooo00?o0000ooooooooool02?ooool01?l0003oooooo`000?l0000iooooo`00
]Oooool01Ol0003ooooooooooooooooo0000013ooooo0_l0000@ooooo`05o`000?oooooooooooooo
ool00000>?ooool00;Kooooo0ol0000>ooooo`?o00004oooool00ol0003oooooooooo`02o`0000go
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000Looooo`00a?ooool3o`0001Kooooo
00?o0000ooooooooool00_l0000<ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooo
ooooooooo`00000Kooooo`00`Oooool3o`000003ooooool0003ooooo01Kooooo00Go0000oooooooo
ooooooooo`000005ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooo
oooo01Wooooo002nooooo`?o00007?ooool01?l0003oooooooooooooool2o`0000_ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`0Iooooo`00^oooool3o`0001oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo1?l0
000Looooo`00^?ooool3o`0002;ooooo00?o0000ooooooooool00oooool2o`0000Wooooo00Co0000
oooooooooooo00001oooool00ol0003oooooooooo`0Mooooo`00]_ooool3o`0002Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooo`00000:ooooo`;o00002?ooool5o`0001_ooooo002coooo
o`?o00000_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0<Oooool00;3ooooo0ol0000Zooooo`03o`000?oooooooooo00Gooooo0_l0000booooo`00
[Oooool3o`0002gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0`ooooo`00Z_oo
ool3o`00033ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0_ooooo`00Q_ooool3
o`0001kooooo0ol00002ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool01Oooool2
o`00037ooooo0025ooooo`05o`000?ooooooooooooooool000006oooool2o`0003Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`06ooooo`;o00009_ooool008Gooooo00Go0000oooo
ooooooooooooo`00000Hooooo`?o0000>Oooool00ol0003oooooooooo`07ooooo`;o00001_ooool0
1?l0003oooooooooool0000Uooooo`00QOooool4o`0001Kooooo0ol0000looooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000Uooooo`00QOooool0
0ol0003oooooooooo`0Dooooo`?o000000?oooooo`000?ooool0??ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00009Oooool008Kooooo00?o0000
ooooooooool04?ooool3o`0004;ooooo00?o0000ooooooooool02Oooool2o`0000Cooooo00Co0000
oooooooooooo00009Oooool008Oooooo0_l0000=ooooo`?o0000AOooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00009Oooool009Cooooo0_l00018
ooooo`03o`000?oooooooooo00Wooooo0ol00004ooooo`;o00009_ooool0097ooooo1?l00019oooo
o`03o`000?oooooooooo00Wooooo1?l0000[ooooo`00S_ooool3o`0004gooooo00?o0000ooooool0
00002Ol00003ooooo`;o0000:_ooool008_ooooo0ol0001@ooooo`;o00003_ooool00ol0003ooooo
ooooo`0Xooooo`00R?ooool3o`00053ooooo0ol000000ooooooo0000ooooo`0=ooooo`03o`000?oo
oooooooo02Sooooo0025ooooo`Co0000DOooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00cooooo0_l0000Yooooo`00Poooool2o`0000?ooooo00?o0000ooooooooool0C_ooool2o`00
00Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`06ooooo`;o00001?ooool00ol0
003oooooooooo`02ooooo`?o00004_ooool0083ooooo0ol0001Eooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool03_ooool2o`0000Kooooo00Co0000oooooooooooo00001oooool01Ol0
003ooooooooooooooooo0000017ooooo001mooooo`?o0000Eoooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00oooooo001Jooooo`?o00007Oooool4o`0005Kooooo0ol00008oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00oooooo001Kooooo`03o`000?oooooooooo01Wooooo0ol0001<oooo
o`ko00002oooool00ol0003oooooooooo`0?ooooo`;o00001Oooool01?l0003oooooooooool00007
ooooo`Co00004_ooool005Sooooo1Ol0000Gooooo`?o0000COooool2o`0001Wooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000
ooooooooool04oooool005Sooooo00Co0000oooooooooooo00005Oooool3o`0004kooooo0_l0000K
ooooo`03o`000?oooooooooo013ooooo0ol00004ooooo`;o00002?ooool5o`00017ooooo001Ioooo
o`03o`000?oooooo000001?ooooo0ol0001?ooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Rooooo`00F_ooool2o`00013ooooo0ol0001Aooooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool04_ooool2o`0002?ooooo001Kooooo`03o`00
0?oooooooooo00_ooooo0ol0001Dooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0
5?ooool00ol0003oooooooooo`0Pooooo`00I_ooool3o`0005Kooooo00?o0000ooooooooool07_oo
ool00ol0003oooooooooo`0Cooooo`;o00008Oooool006?ooooo1?l0001Gooooo`03o`000?oooooo
oooo01oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Oooooo`00H?ooool3o`00
04Wooooo2?l00008ooooo`;o00008_ooool00ol0003oooooooooo`0Dooooo`;o00001oooool3o`00
00?ooooo0ol0000@ooooo`00G_ooool2o`0004[ooooo0_l00008ooooo`So00009?ooool00ol0003o
ooooooooo`0Dooooo`;o00002?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oo
oooo001Kooooo`?o0000Boooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool00oooool5o`0000?ooooo00?o0000ooooooooool03oooool005Sooooo1?l0
001<ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool05_ooool2o`0000Kooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0?ooooo`00EOooool3o`0000?ooooo00?o0000
ooooooooool0B_ooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001Boooo
o`?o0000D_ooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo01Kooooo0ol00004oooo
o`;o00001?ooool2o`00017ooooo000]ooooo`Go00007Oooool3o`0005Gooooo00?o0000oooooooo
ool0=_ooool00ol0003oooooooooo`0Cooooo`?o00000_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool03oooool002kooooo00Co0000oooooooooooo
00006oooool2o`000003ooooool0003ooooo04;ooooo0_l0000Aooooo`03o`000?oooooooooo03Ko
oooo00?o0000ooooooooool04?ooool3o`0000Gooooo00?o0000ooooooooool06oooool002oooooo
00?o0000ooooooooool06?ooool3o`0004Gooooo0_l00002ooooo`Go00002oooool00ol0003ooooo
ooooo`0gooooo`03o`000?oooooooooo00gooooo0ol00008ooooo`;o00007?ooool0033ooooo00?o
0000ooooooooool05?ooool3o`0004Oooooo00?o0000ooooooooool01oooool4o`0000Gooooo0_l0
000kooooo`03o`000?oooooooooo00Wooooo0ol0000;ooooo`03o`000?oooooooooo01_ooooo000]
ooooo`05o`000?ooooooooooooooool000004_ooool3o`0004[ooooo00?o0000ooooooooool02ooo
ool5o`0003gooooo00?o0000ooooooooool01_ooool3o`0000oooooo00?o0000ooooooooool06_oo
ool002gooooo00Go0000ooooooooooooooooo`00000?ooooo`?o000000?oooooo`000?ooool0BOoo
ool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo00?ooooo0ol0000Booooo`03o`000?oo
oooooooo01[ooooo000^ooooo`?o00003Oooool3o`0004oooooo00?o0000ooooooooool0C_ooool0
0ol0003oooooooooo`03o`0001Cooooo0_l0000Looooo`00??ooool2o`0005;ooooo00?o0000oooo
ooooool0C_ooool3o`0001Sooooo00?o0000ooooooooool06_ooool003Wooooo0ol0000nooooo`Go
00004Oooool00ol0003oooooooooo`1;ooooo`Co00006_ooool00ol0003oooooooooo`0Jooooo`00
=_ooool3o`000003ooooool0003ooooo03gooooo00?o0000ooooooooool00oooool2o`0000kooooo
00?o0000ooooooooool0BOooool3o`0000?ooooo00?o0000ooooooooool06?ooool00ol0003ooooo
ooooo`0Jooooo`00<oooool3o`0004?ooooo00?o0000ooooooooool01Oooool3o`0000_ooooo00?o
0000ooooooooool0A_ooool3o`0000Kooooo00?o0000ooooooooool06?ooool00ol0003ooooooooo
o`09ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00000oooool0033ooooo0ol00015
ooooo`03o`000?oooooooooo00Wooooo1?l00006ooooo`03o`000?oooooooooo04Cooooo0ol00009
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool0
0007ooooo`05o`000?ooooooooooooooool000000_ooool002gooooo1?l00017ooooo`03o`000?oo
oooooooo00gooooo0_l00004ooooo`03o`000?oooooooooo043ooooo1?l0000<ooooo`03o`000?oo
oooooooo01Sooooo0_l00002ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`7o0000
0Oooool1ooooo`00:_ooool3o`0000?ooooo00?o0000ooooooooool0AOooool00ol0003ooooooooo
o`0?ooooo`Co0000@?ooool3o`00013ooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`07ooooo`04o`000?ooooooooooo`0000_ooooo0Ol00001ooooo`7ooooo000Xooooo`;o0000>?oo
ool3o`0001Cooooo00?o0000ooooooooool0Coooool3o`0001Cooooo00?o0000ooooooooool06?oo
ool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000Oooooo1?l00003ooooo`001_oo
ool2o`0001gooooo0ol0000iooooo`04o`000?ooooooooooooooo`Co00004?ooool00ol0003ooooo
ooooo`1<ooooo`?o00005oooool00ol0003oooooooooo`0Gooooo`;o00002Oooool01?l0003ooooo
ooooool00007ooooo`03o`000?oooooooooo00Cooooo0005ooooo`04o`000?ooooooooooo`0001Wo
oooo1?l0000kooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`19ooooo`?o00006_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00So
oooo0_l00008ooooo`Go00000_ooool000Gooooo00Co0000oooooooooooo00005_ooool3o`0003oo
oooo00?o0000ooooooooool01_ooool2o`0000gooooo00?o0000ooooooooool0A_ooool3o`0001go
oooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Iooooo`001Oooool01?l0003ooooo
ooooool0000Cooooo`?o0000@_ooool00ol0003oooooooooo`08ooooo`?o00002_ooool00ol0003o
ooooooooo`13ooooo`?o00008?ooool00ol0003oooooooooo`0Hooooo`;o00006_ooool000Gooooo
00Co0000oooooooooooo00004?ooool3o`0002gooooo0ol0000Eooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`10ooooo`?o00008Oooool3o`0001[o
oooo00?o0000ooooooooool06Oooool000Gooooo00Co0000oooooooooooo00003_ooool2o`0000;o
oooo00?o0000ooooooooool0:_ooool01?l0003oooooooooooooool3o`0001;ooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo03gooooo0ol0000Qoooo
o`?o00000_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo01Wooooo0006ooooo`;o
00003?ooool3o`00037ooooo00?o0000ooooooooool01?ooool2o`00013ooooo00?o0000oooooooo
ool03Oooool5o`0000?ooooo00?o0000ooooooooool0>_ooool3o`00027ooooo0ol00006ooooo`03
o`000?oooooooooo01Oooooo0_l0000Jooooo`004Oooool3o`0003Cooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo017ooooo0ol0000jooooo`?o0000
8Oooool3o`0000[ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Hooooo`003_oo
ool4o`0001gooooo1?l0000Eooooo`03o`000?oooooooooo00Oooooo0_l0000>ooooo`03o`000?oo
oooooooo04_ooooo0ol0000Qooooo`?o00003_ooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo01Sooooo000;ooooo`?o00008Oooool01?l0003oooooooooooooool2o`0001Cooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo04Oooooo0ol0
000Pooooo`Co00004Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo01Sooooo0008
ooooo`?o00009?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool02Oooool2o`0000cooooo00?o0000ooooooooool0@oooool4o`00023ooooo0ol0000F
ooooo`03o`000?oooooooooo01Cooooo0_l0000Jooooo`001oooool2o`0000_ooooo1Ol0000Goooo
o`03o`000?oooooooooo00?ooooo0_l0000Booooo`03o`000?oooooooooo00[ooooo0_l0000:oooo
o`03o`000?oooooooooo043ooooo0ol0000Qooooo`?o00006_ooool00ol0003oooooooooo`0Doooo
o`03o`000?oooooooooo00?ooooo0_l0000Cooooo`001oooool00ol0003oooooo`00000:ooooo`03
o`000?oooooooooo00;ooooo0_l0000Eooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0<ooooo`;o00002?ooool00ol0003oooooooooo`0mooooo`?o
00008Oooool3o`0001gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0001;ooooo0006ooooo`;o00000_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo03[ooooo0ol0000Qooooo`?o00008Oooool00ol0003oooooooooo`0Cooooo`;o
00000oooool01?l0003oooooooooool0000Booooo`001oooool01Ol0003ooooooooooooooooo0000
00Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
00Kooooo0_l0000?ooooo`03o`000?oooooooooo00kooooo0ol00005ooooo`03o`000?oooooooooo
03Kooooo0ol0000Qooooo`?o00009Oooool00ol0003oooooooooo`0Cooooo`05o`000?oooooooooo
ooooool000000_ooool00ol0003oooooooooo`0@ooooo`001oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool2o`0001;ooooo00?o0000oooo
ooooool02?ooool2o`0000kooooo00?o0000ooooooooool04?ooool2o`0000?ooooo00?o0000oooo
ooooool0<oooool3o`00023ooooo1?l0000Yooooo`03o`000?oooooooooo01;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooooooo013ooooo0007ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
01;ooooo0ol0000cooooo`?o00008?ooool3o`0002gooooo00?o0000ooooooooool04Oooool2o`00
00?ooooo00Co0000oooooooooooo00004_ooool000Kooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`09ooooo`;o00003?ooool00ol0003oooooooooo`14ooooo`?o00008?ooool3o`00
037ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`02ooooo`;o00004oooool000Ko
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool0@?ooool3o`00023ooooo0ol0000eooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool05oooool000Kooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00Kooooo0_l0000@ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0mooooo`?o00008?ooool3o`0003Sooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Gooooo`001_ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo00_ooooo0_l0000:ooooo`03o`000?oooooooooo03Wooooo0ol0
000Oooooo`Co0000??ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01Oooooo0006
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`08
ooooo`;o00003oooool00ol0003oooooooooo`0<ooooo`;o00002?ooool00ol0003oooooooooo`0f
ooooo`?o00007oooool3o`00047ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0G
ooooo`001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00gooooo0_l00006oooo
o`03o`000?oooooooooo03?ooooo0ol0000Oooooo`?o0000AOooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo01Kooooo0006ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`09ooooo`;o00003Oooool00ol0003oooooooooo`0?ooooo`;o
00001Oooool00ol0003oooooooooo`0_ooooo`?o00007oooool3o`0004Sooooo00?o0000oooooooo
ool03Oooool2o`0001Sooooo0006ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02_ooooo1?l0000Oooooo`?o0000
C?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Kooooo0006ooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`;o00003?oo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool09ooo
ool3o`00023ooooo0ol0001@ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05_oo
ool000Gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Aooooo`;o000000?ooooo
o`000?ooool09_ooool3o`0001oooooo1?l0001Cooooo`03o`000?oooooooooo00_ooooo0_l0000H
ooooo`001Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool03?ooool2o`0000[ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Soooo
o`?o00007oooool3o`0005Sooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Foooo
o`001Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo03Gooooo0ol0000Oooooo`?o
0000G?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo0_l00004ooooo`03
o`000?oooooooooo00;ooooo0ol00005ooooo`001Oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo037ooooo0ol0000Oooooo`?o0000H?ooool00ol0003oooooooooo`09ooooo`;o0000
0oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool000Go
oooo00?o0000ooooooooool04oooool2o`0000Gooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo02gooooo0ol0000Oooooo`?o0000Hoooool00ol0003o
ooooooooo`09ooooo`;o00000oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo
00;ooooo0005ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0>ooooo`;o00001oooool00ol0003oooooooooo`0Zooooo`?o00007_ooool4o`0006Oo
oooo00?o0000ooooooooool02Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`02ooooo`001Oooool00ol0003oooooooooo`0Fooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool03oooool2o`0000Kooooo00?o0000oooooooo
ool09_ooool3o`0001kooooo0ol0001/ooooo`03o`000?oooooooooo00Sooooo00Go0000oooooooo
ooooooooo`000002ooooo`03o`000?oooooooooo00Gooooo1?l00005ooooo`001Oooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo02?ooooo0ol0000Nooooo`?o0000Koooool00ol0003o
ooooooooo`06ooooo`?o00000oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo
00Kooooo0005ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0@ooooo`;o00001?ooool00ol0003oooooooooo`0Oooooo`?o00007_ooool3o`0007?o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`;o00002?ooool5o`0000Co
oooo0004ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0Aooooo`05o`000?ooooooooooooooool000007_ooool3o`0001kooooo0ol0001gooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool05Oooool000Cooooo00?o0000ooooooooool0
6oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo017ooooo0ol000000ooooooo0000
ooooo`0Iooooo`?o00007_ooool3o`0007_ooooo00?o0000ooooooooool01?ooool2o`0001Oooooo
0004ooooo`03o`000?oooooooooo01cooooo00Go0000ooooooooooooooooo`00000Fooooo`;o0000
5_ooool4o`0001gooooo1?l0001nooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
5Oooool000Cooooo00?o0000ooooooooool07Oooool01Ol0003ooooooooooooooooo000002[ooooo
0ol0000Nooooo`?o0000Poooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Gooooo
0004ooooo`03o`000?oooooooooo01kooooo00Go0000ooooooooooooooooo`00000Vooooo`?o0000
7_ooool3o`0008Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Dooooo`001?oo
ool00ol0003oooooooooo`0Oooooo`05o`000?ooooooooooooooool000008_ooool3o`0001kooooo
0ol0002:ooooo`03o`000?oooooooooo00?ooooo0_l0000Fooooo`001?ooool00ol0003ooooooooo
o`0Pooooo`05o`000?ooooooooooooooool000007_ooool3o`0001kooooo0ol0002>ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool05?ooool000Cooooo00?o0000ooooooooool08Ooo
ool01?l0003oooooooooool0000Kooooo`?o00007Oooool4o`0009;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0Dooooo`001?ooool00ol0003oooooooooo`0Rooooo`04o`000?oo
ooooooooo`0001Oooooo0ol0000Mooooo`?o0000Uoooool00ol0003oooooooooo`02o`0001Kooooo
0003ooooo`03o`000?oooooooooo02Cooooo00Co0000oooooooooooo00004oooool3o`0001gooooo
0ol0002Jooooo`05o`000?ooooooooooooooool000005_ooool000?ooooo00?o0000ooooooooool0
9Oooool01?l0003oooooooooool0000?ooooo`?o00007Oooool3o`0009kooooo00Co0000oooooooo
oooo00001?ooool3o`0000oooooo0003ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooool0
00003?ooool3o`0001gooooo0ol0002Rooooo`04o`000?oooooo0000o`0000Cooooo00?o0000oooo
ooooool03_ooool000?ooooo00?o0000ooooooooool09oooool00ol0003oooooo`000008ooooo`?o
00007Oooool3o`000:Gooooo00Co0000ooooool0003o00001?ooool00ol0003oooooooooo`0>oooo
o`000oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooo000000Cooooo0ol0000Looooo`Co
0000ZOooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00kooooo0003ooooo`03o`00
0?oooooooooo02Wooooo0_l000001?oooooo0000o`000?l0000Looooo`?o0000[_ooool2o`0000Co
oooo00?o0000ooooooooool03_ooool000?ooooo00?o0000ooooooooool0:_ooool2o`0001cooooo
0ol0002`ooooo`?o00000oooool2o`00013ooooo0003ooooo`03o`000?oooooooooo02[ooooo00?o
0000ooooooooool06?ooool3o`000;3ooooo0ol00007ooooo`03o`000?oooooooooo00kooooo0003
ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool05Oooool3o`000:oooooo1?l0000K
ooooo`000_ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo017ooooo1?l0002_oooo
o`?o00007oooool000;ooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`0>ooooo`?o
0000[oooool4o`0002;ooooo0002ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool0
2oooool3o`000:oooooo0ol0000Vooooo`000_ooool00ol0003oooooooooo`0[ooooo`03o`000?oo
oooooooo00Sooooo0ol0002^ooooo`Co0000:Oooool000;ooooo00?o0000ooooooooool0:oooool0
0ol0003oooooooooo`05ooooo`?o0000[_ooool3o`0002gooooo0002ooooo`03o`000?oooooooooo
02_ooooo00?o0000ooooooooool00_ooool3o`000:kooooo0ol0000`ooooo`000_ooool00ol0003o
ooooooooo`0Zooooo`03o`000?oooooo000000?o0000[Oooool4o`0003?ooooo0002ooooo`03o`00
0?oooooooooo02Wooooo0ol0002^ooooo`?o0000=oooool000;ooooo00?o0000ooooooooool09_oo
ool3o`000003ooooool0003ooooo0:[ooooo1?l0000jooooo`0000?oooooo`000?ooool09Oooool3
o`0000Cooooo00?o0000ooooooooool0Y_ooool3o`0003kooooo00000ooooooo0000ooooo`0Roooo
o`?o00001oooool00ol0003oooooooooo`2Rooooo`Co0000@Oooool00003ooooool0003ooooo01ko
oooo1?l0000:ooooo`03o`000?oooooooooo09oooooo0ol00015ooooo`0000?oooooo`000?ooool0
6oooool3o`0000kooooo00?o0000ooooooooool0Voooool4o`0004Sooooo00000ooooooo0000oooo
o`0Hooooo`?o00004Oooool00ol0003oooooooooo`2Hooooo`?o0000C?ooool00003ooooool0003o
oooo01Gooooo0ol0000Dooooo`03o`000?oooooooooo09Cooooo1?l0001?ooooo`0000?oooooo`00
0?ooool04_ooool3o`0001Oooooo00?o0000ooooooooool0TOooool3o`0005?ooooo00000ooooooo
0000ooooo`0?ooooo`?o00006_ooool00ol0003oooooooooo`2=ooooo`Co0000E_ooool00003oooo
ool0003ooooo00_ooooo1?l0000Mooooo`03o`000?oooooooooo08[ooooo0ol0001Jooooo`0000?o
0000ooooooooool02?ooool3o`00027ooooo00?o0000ooooooooool0Q_ooool4o`0005gooooo0000
0ol0003oooooooooo`05ooooo`?o00009?ooool00ol0003oooooooooo`23ooooo`?o0000HOooool0
0003o`000?oooooooooo00;ooooo0ol0000Wooooo`03o`000?oooooooooo083ooooo0ol0001Toooo
o`0000?o0000ooooool000000_l0000Yooooo`03o`000?oooooooooo07gooooo1?l0001Wooooo`00
0_l0000/ooooo`03o`000?oooooooooo07[ooooo0ol0001[ooooo`000_ooool00ol0003ooooooooo
o`0Yooooo`03o`000?oooooooooo07Kooooo1?l0001^ooooo`000oooool00ol0003oooooooooo`0X
ooooo`03o`000?oooooooooo07?ooooo0ol0001booooo`001?ooool00ol0003oooooooooo`0Woooo
o`03o`000?oooooooooo06oooooo1?l0001eooooo`001Oooool00ol0003oooooooooo`0Vooooo`03
o`000?oooooooooo06cooooo0ol0001iooooo`001_ooool2o`0002Kooooo00?o0000ooooooooool0
J?ooool4o`0007cooooo0008ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool0IOoo
ool3o`00083ooooo0009ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0HOooool4
o`0008?ooooo000:ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0G_ooool3o`00
08Oooooo000;ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0F_ooool4o`0008[o
oooo000<ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0Eoooool3o`0008kooooo
000=ooooo`;o00007oooool00ol0003oooooooooo`1Cooooo`Co0000TOooool000oooooo00?o0000
ooooooooool07?ooool00ol0003oooooooooo`1@ooooo`?o0000UOooool0013ooooo00?o0000oooo
ooooool06oooool00ol0003oooooooooo`1<ooooo`Co0000V?ooool0017ooooo00?o0000oooooooo
ool06_ooool00ol0003oooooooooo`19ooooo`?o0000W?ooool001;ooooo00?o0000ooooooooool0
6?ooool00ol0003oooooooooo`17ooooo`?o0000Woooool001?ooooo0_l0000Hooooo`03o`000?oo
oooooooo04?ooooo1?l0002Rooooo`005Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooo
oooo043ooooo0ol0002Vooooo`005_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
03cooooo1?l0002Yooooo`005oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo03Wo
oooo0ol0002]ooooo`006?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo03Gooooo
1?l0002`ooooo`006Oooool2o`0001;ooooo00?o0000ooooooooool0<_ooool3o`000;Cooooo000K
ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0;_ooool4o`000;Oooooo000Loooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool0:oooool3o`000;_ooooo000Mooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool09oooool4o`000;kooooo000Nooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool09?ooool3o`000<;ooooo000Oooooo`;o00003?oo
ool00ol0003oooooooooo`0Pooooo`Co0000aOooool0027ooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0Mooooo`?o0000bOooool002;ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0Iooooo`Co0000c?ooool002?ooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`0Fooooo`?o0000d?ooool002Cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Dooooo`?o0000doooool002Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0@ooooo`Co0000e_ooool002Kooooo0_l00004ooooo`03o`000?oooooooooo00gooooo0ol0003J
ooooo`00:?ooool01Ol0003ooooooooooooooooo000000_ooooo1?l0003Mooooo`00:Oooool01?l0
003oooooooooool00008ooooo`?o0000hOooool002[ooooo00?o0000ooooool000001?ooool4o`00
0>Cooooo000[ooooo`;o000000Coooooo`000?l0003o0000j?ooool002cooooo0_l0003[ooooo`00
oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00\
\>"],
  ImageRangeCache->{{{0, 280.875}, {190.438, 0}} -> {0.0219893, 0.106871, \
0.00376814, 0.00376814}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Second Solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p3 = 
        ParametricPlot3D[{t, 1, E\^\(-\(t\/3\)\)\ Sin[6\ t]}, {t, 0, 
            3\ \[Pi],  .05}, Boxed \[Rule] True, 
          PlotRange \[Rule] {{0, 3\ \[Pi]}, {\(-1\), 1}, {\(-1\), 1}}, 
          BoxRatios \[Rule] {3, 1, 1}];\)\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .67912 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0224888 1.02249 -0.150431 1.02249 [
[.02846 .27668 -2.67377 -9 ]
[.02846 .27668 3.32623 0 ]
[.18704 .22058 -2.78329 -9 ]
[.18704 .22058 3.21671 0 ]
[.35321 .1618 -2.90126 -9 ]
[.35321 .1618 3.09874 0 ]
[.52756 .10014 -3.0287 -9 ]
[.52756 .10014 2.9713 0 ]
[.71068 .0354 -3.1668 -9 ]
[.71068 .0354 2.8332 0 ]
[.86008 -0.00425 0 -6.08625 ]
[.86008 -0.00425 12 2.91375 ]
[.8924 .04484 0 -6.05064 ]
[.8924 .04484 24 2.94936 ]
[.92355 .09216 0 -6.0166 ]
[.92355 .09216 6 2.9834 ]
[.9536 .13781 0 -5.98402 ]
[.9536 .13781 18 3.01598 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 6 3.04719 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 12 3.04719 ]
[.9897 .2427 0 -5.91612 ]
[.9897 .2427 24 3.08388 ]
[.99701 .30533 0 -5.87841 ]
[.99701 .30533 6 3.12159 ]
[1.00453 .36986 0 -5.83963 ]
[1.00453 .36986 18 3.16037 ]
[1.01228 .43637 0 -5.79975 ]
[1.01228 .43637 6 3.20025 ]
[ 0 0 0 0 ]
[ 1 .67912 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.84803 0 m
.842 .00212 L
s
[(-1)] .86008 -0.00425 -1 .3525 Mshowa
.88031 .049 m
.87427 .05108 L
s
[(-0.5)] .8924 .04484 -1 .34459 Mshowa
.91144 .09624 m
.90538 .09828 L
s
[(0)] .92355 .09216 -1 .33702 Mshowa
.94146 .14181 m
.93539 .14381 L
s
[(0.5)] .9536 .13781 -1 .32978 Mshowa
.97045 .1858 m
.96437 .18777 L
s
[(1)] .98261 .18188 -1 .32285 Mshowa
.125 Mabswid
.85458 .00995 m
.85096 .01122 L
s
.86108 .01982 m
.85746 .02108 L
s
.86754 .02962 m
.86392 .03088 L
s
.87395 .03934 m
.87033 .0406 L
s
.88663 .05859 m
.883 .05983 L
s
.8929 .0681 m
.88927 .06934 L
s
.89912 .07755 m
.89549 .07878 L
s
.9053 .08693 m
.90167 .08816 L
s
.91753 .10548 m
.91389 .1067 L
s
.92358 .11466 m
.91994 .11588 L
s
.92958 .12378 m
.92594 .12499 L
s
.93554 .13283 m
.9319 .13403 L
s
.94734 .15073 m
.9437 .15193 L
s
.95318 .15959 m
.94953 .16078 L
s
.95898 .16839 m
.95533 .16958 L
s
.96473 .17713 m
.96108 .17831 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
.25 Mabswid
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
.18827 .43833 m
.02708 .28938 L
s
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.18827 .43833 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
0 0 m
1 0 L
1 .67912 L
0 .67912 L
closepath
clip
newpath
.5 Mabswid
.24329 .44744 m
.24711 .44635 L
s
.23902 .45664 m
.24329 .44744 L
s
.24711 .44635 m
.25051 .4531 L
s
.23429 .47357 m
.23902 .45664 L
s
.25051 .4531 m
.25355 .46682 L
s
.22915 .4972 m
.23429 .47357 L
s
.25355 .46682 m
.25634 .48607 L
s
.22368 .52587 m
.22915 .4972 L
s
.18026 .55551 m
.18171 .58968 L
s
.25634 .48607 m
.25898 .50899 L
s
.218 .55735 m
.22368 .52587 L
s
.32353 .44763 m
.32744 .44713 L
s
.3194 .45396 m
.32353 .44763 L
s
.25898 .50899 m
.26158 .53341 L
s
.31505 .46587 m
.3194 .45396 L
s
.32744 .44713 m
.33116 .4522 L
s
.31049 .48265 m
.31505 .46587 L
s
.33116 .4522 m
.33472 .46215 L
s
.18171 .58968 m
.18348 .62003 L
s
.21226 .589 m
.218 .55735 L
s
.30575 .50313 m
.31049 .48265 L
s
.33472 .46215 m
.33818 .4759 L
s
.26158 .53341 m
.26428 .55703 L
s
.30089 .52572 m
.30575 .50313 L
s
.20664 .61798 m
.21226 .589 L
s
.33818 .4759 m
.34159 .49206 L
s
.18348 .62003 m
.18574 .64369 L
s
.26428 .55703 m
.26717 .57761 L
s
.296 .54857 m
.30089 .52572 L
s
.34159 .49206 m
.345 .50905 L
s
.20132 .64147 m
.20664 .61798 L
s
.4068 .4401 m
.41083 .43983 L
s
.40269 .44455 m
.4068 .4401 L
s
.3985 .45301 m
.40269 .44455 L
s
.18574 .64369 m
.18863 .65845 L
s
.41083 .43983 m
.4148 .44349 L
s
.39423 .46502 m
.3985 .45301 L
s
.29114 .56967 m
.296 .54857 L
s
.26717 .57761 m
.27034 .59323 L
s
.4148 .44349 m
.41873 .45057 L
s
.345 .50905 m
.34848 .52522 L
s
.19646 .65705 m
.20132 .64147 L
s
.38988 .47973 m
.39423 .46502 L
s
.18863 .65845 m
.19221 .66299 L
s
.41873 .45057 m
.42264 .46023 L
s
.28642 .58707 m
.29114 .56967 L
s
.38547 .49605 m
.38988 .47973 L
s
.19221 .66299 m
.19646 .65705 L
s
.27034 .59323 m
.27385 .60242 L
s
.34848 .52522 m
.35207 .53905 L
s
.42264 .46023 m
.42655 .47147 L
s
.38104 .51267 m
.38547 .49605 L
s
.28192 .59907 m
.28642 .58707 L
s
.27385 .60242 m
.27771 .60439 L
s
.27771 .60439 m
.28192 .59907 L
s
.35207 .53905 m
.3558 .5492 L
s
.3766 .52817 m
.38104 .51267 L
s
.42655 .47147 m
.43049 .48313 L
s
.37222 .54117 m
.3766 .52817 L
s
.3558 .5492 m
.35968 .55473 L
s
.43049 .48313 m
.43446 .49407 L
s
.48864 .42999 m
.49279 .42676 L
s
.48448 .43611 m
.48864 .42999 L
s
.49279 .42676 m
.49696 .4265 L
s
.48032 .4448 m
.48448 .43611 L
s
.49696 .4265 m
.50113 .42902 L
s
.36791 .55047 m
.37222 .54117 L
s
.35968 .55473 m
.36372 .55515 L
s
.47614 .45548 m
.48032 .4448 L
s
.36372 .55515 m
.36791 .55047 L
s
.50113 .42902 m
.50533 .43391 L
s
.47194 .46738 m
.47614 .45548 L
s
.43446 .49407 m
.43848 .5032 L
s
.50533 .43391 m
.50955 .44056 L
s
.46773 .47957 m
.47194 .46738 L
s
.43848 .5032 m
.44256 .50964 L
s
.50955 .44056 m
.5138 .44822 L
s
.4635 .49107 m
.46773 .47957 L
s
.44256 .50964 m
.44668 .51275 L
s
.45927 .50089 m
.4635 .49107 L
s
.5138 .44822 m
.51807 .45609 L
s
.45505 .50817 m
.45927 .50089 L
s
.44668 .51275 m
.45085 .51225 L
s
.45085 .51225 m
.45505 .50817 L
s
.51807 .45609 m
.52236 .46333 L
s
.57711 .41147 m
.58135 .409 L
s
.57291 .41601 m
.57711 .41147 L
s
.56874 .42241 m
.57291 .41601 L
s
.58135 .409 m
.58565 .40865 L
s
.52236 .46333 m
.52665 .46921 L
s
.5646 .43027 m
.56874 .42241 L
s
.58565 .40865 m
.58999 .41024 L
s
.56046 .43905 m
.5646 .43027 L
s
.58999 .41024 m
.59439 .41348 L
s
.52665 .46921 m
.53095 .47311 L
s
.55631 .44811 m
.56046 .43905 L
s
.55215 .45675 m
.55631 .44811 L
s
.59439 .41348 m
.59882 .41792 L
s
.53095 .47311 m
.53524 .47463 L
s
.54797 .46426 m
.55215 .45675 L
s
.53524 .47463 m
.53951 .47358 L
s
.54375 .47003 m
.54797 .46426 L
s
.59882 .41792 m
.6033 .423 L
s
.53951 .47358 m
.54375 .47003 L
s
.6033 .423 m
.60779 .42816 L
s
.60779 .42816 m
.61229 .4328 L
s
.61229 .4328 m
.61677 .43641 L
s
.66375 .39334 m
.66804 .38985 L
s
.65951 .39816 m
.66375 .39334 L
s
.61677 .43641 m
.62122 .43859 L
s
.66804 .38985 m
.67239 .38786 L
s
.65532 .40406 m
.65951 .39816 L
s
.67239 .38786 m
.67681 .38735 L
s
.65114 .41066 m
.65532 .40406 L
s
.64697 .4175 m
.65114 .41066 L
s
.67681 .38735 m
.6813 .38822 L
s
.62122 .43859 m
.62564 .43905 L
s
.64279 .42409 m
.64697 .4175 L
s
.62564 .43905 m
.63 .4377 L
s
.6813 .38822 m
.68585 .39022 L
s
.63857 .42993 m
.64279 .42409 L
s
.63 .4377 m
.63431 .43458 L
s
.63431 .43458 m
.63857 .42993 L
s
.68585 .39022 m
.69045 .39303 L
s
.69045 .39303 m
.69508 .39625 L
s
.69508 .39625 m
.69973 .39947 L
s
.69973 .39947 m
.70437 .40227 L
s
.70437 .40227 m
.70899 .40431 L
s
.70899 .40431 m
.71357 .40531 L
s
.71357 .40531 m
.71809 .40507 L
s
.75266 .37232 m
.757 .36856 L
s
.74837 .37686 m
.75266 .37232 L
s
.757 .36856 m
.7614 .36578 L
s
.7441 .38192 m
.74837 .37686 L
s
.71809 .40507 m
.72255 .40355 L
s
.7614 .36578 m
.76588 .36405 L
s
.73985 .3872 m
.7441 .38192 L
s
.73558 .39233 m
.73985 .3872 L
s
.72255 .40355 m
.72695 .40079 L
s
.76588 .36405 m
.77043 .36339 L
s
.73129 .39697 m
.73558 .39233 L
s
.72695 .40079 m
.73129 .39697 L
s
.77043 .36339 m
.77504 .36368 L
s
.77504 .36368 m
.77972 .36475 L
s
.77972 .36475 m
.78445 .36636 L
s
.78445 .36636 m
.78921 .36824 L
s
.78921 .36824 m
.79398 .37007 L
s
.79398 .37007 m
.79873 .37159 L
s
.79873 .37159 m
.80346 .37253 L
s
.80346 .37253 m
.80814 .37271 L
s
.80814 .37271 m
.81276 .37201 L
s
.81276 .37201 m
.81733 .37039 L
s
.81733 .37039 m
.82183 .36792 L
s
.82183 .36792 m
.82628 .3647 L
s
.82628 .3647 m
.83068 .36093 L
s
.83943 .35266 m
.84382 .34866 L
s
.83506 .35683 m
.83943 .35266 L
s
.84382 .34866 m
.84824 .34506 L
s
.83068 .36093 m
.83506 .35683 L
s
.84824 .34506 m
.85271 .34203 L
s
.85271 .34203 m
.85724 .3397 L
s
.85724 .3397 m
.86184 .33812 L
s
.86184 .33812 m
.86651 .33729 L
s
.86651 .33729 m
.87125 .33713 L
s
.87125 .33713 m
.87604 .33751 L
s
.87604 .33751 m
.88088 .33825 L
s
.88088 .33825 m
.88575 .33915 L
s
.88575 .33915 m
.89062 .33999 L
s
.89062 .33999 m
.89547 .34059 L
s
.89547 .34059 m
.9003 .34076 L
s
.9003 .34076 m
.90508 .34038 L
s
.90508 .34038 m
.90981 .33937 L
s
.90981 .33937 m
.91448 .33771 L
s
.91448 .33771 m
.9191 .33545 L
s
.9191 .33545 m
.92367 .33267 L
s
.92367 .33267 m
.9282 .32952 L
s
.9282 .32952 m
.93272 .32615 L
s
.93272 .32615 m
.93723 .32275 L
s
.93723 .32275 m
.94175 .31949 L
s
.94175 .31949 m
.94631 .31653 L
s
.94631 .31653 m
.95092 .31398 L
s
.95092 .31398 m
.95559 .31194 L
s
.95559 .31194 m
.96032 .31043 L
s
.96032 .31043 m
.96512 .30945 L
s
.96512 .30945 m
.96997 .30894 L
s
.96997 .30894 m
.97488 .30879 L
s
.97488 .30879 m
.97982 .30889 L
s
.97982 .30889 m
.98478 .30908 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.875, 191.438},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000_b000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00i_ooool3
o`00033ooooo003Wooooo`03o`000?oooooooooo02oooooo003Oooooo`Go00000oooool00ol0003o
ooooooooo`0_ooooo`00ioooool00ol0003oooooooooo`0_ooooo`00ioooool00ol0003ooooooooo
o`0_ooooo`00i_ooool2o`00037ooooo003Jooooo`?o00002_ooool00ol0003oooooooooo`0_oooo
o`00]_ooool3o`0001oooooo0ol000000ooooooo0000ooooo`0kooooo`00]Oooool01Ol0003ooooo
oooooooooooo000001_ooooo0ol00004ooooo`;o0000>oooool00;Gooooo00Go0000oooooooooooo
ooooo`00000Hooooo`?o00001oooool00ol0003oooooo`00000jooooo`00]_ooool3o`0001Kooooo
0ol0000:ooooo`03o`000?oooooo000003[ooooo002eooooo`05o`000?ooooooooooooooool00000
4_ooool3o`0000;ooooo00?o0000ooooooooool02?ooool01?l0003oooooo`000?l0000iooooo`00
]Oooool01Ol0003ooooooooooooooooo0000013ooooo0_l0000@ooooo`05o`000?oooooooooooooo
ool00000>?ooool00;Kooooo0ol0000>ooooo`?o00004oooool00ol0003oooooooooo`02o`0000go
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000Looooo`00a?ooool3o`0001Kooooo
00?o0000ooooooooool00_l0000<ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooo
ooooooooo`00000Kooooo`00`Oooool3o`000003ooooool0003ooooo01Kooooo00Go0000oooooooo
ooooooooo`000005ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooo
oooo01Wooooo002nooooo`?o00007?ooool01?l0003oooooooooooooool2o`0000_ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`0Iooooo`00^oooool3o`0001oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo1?l0
000Looooo`00^?ooool3o`0002;ooooo00?o0000ooooooooool00oooool2o`0000Wooooo00Co0000
oooooooooooo00001oooool00ol0003oooooooooo`0Mooooo`00]_ooool3o`0002Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooo`00000:ooooo`;o00002?ooool5o`0001_ooooo002coooo
o`?o00000_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0<Oooool00;3ooooo0ol0000Zooooo`03o`000?oooooooooo00Gooooo0_l0000booooo`00
[Oooool3o`0002gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0`ooooo`00Z_oo
ool3o`00033ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0_ooooo`00Q_ooool3
o`0001kooooo0ol00002ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool01Oooool2
o`00037ooooo0025ooooo`05o`000?ooooooooooooooool000006oooool2o`0003Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`06ooooo`;o00009_ooool008Gooooo00Go0000oooo
ooooooooooooo`00000Hooooo`?o0000>Oooool00ol0003oooooooooo`07ooooo`;o00001_ooool0
1?l0003oooooooooool0000Uooooo`00QOooool4o`0001Kooooo0ol0000looooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000Uooooo`00QOooool0
0ol0003oooooooooo`0Dooooo`?o000000?oooooo`000?ooool0??ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00009Oooool008Kooooo00?o0000
ooooooooool04?ooool3o`0004;ooooo00?o0000ooooooooool02Oooool2o`0000Cooooo00Co0000
oooooooooooo00009Oooool008Oooooo0_l0000=ooooo`?o0000AOooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00009Oooool009Cooooo0_l00018
ooooo`03o`000?oooooooooo00Wooooo0ol00004ooooo`;o00009_ooool0097ooooo1?l00019oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0:_ooool008kooooo0ol0001=ooooo`03
o`000?oooooooooo00cooooo0_l0000Zooooo`00Roooool3o`00053ooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`0Xooooo`00R?ooool3o`0005Cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Xooooo`00QOooool4o`0005Kooooo00?o0000ooooooooool03?ooool2
o`0002Wooooo0023ooooo`;o00000oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool01_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`00
01;ooooo0020ooooo`?o0000G?ooool00ol0003oooooooooo`0>ooooo`;o00001_ooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000004Oooool007gooooo0ol0001Ooooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00oooooo001Jooooo`?o00007Oooool4o`00067ooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000
ooooooooool03oooool005_ooooo00?o0000ooooooooool06Oooool3o`0006Gooooo00?o0000oooo
ooooool03oooool2o`0000Gooooo00Co0000oooooooooooo00001oooool4o`0001;ooooo001Hoooo
o`Go00005oooool3o`0006Sooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool04oooool005Sooooo00Co0000oooo
oooooooo00005Oooool3o`0006_ooooo00?o0000ooooooooool04?ooool3o`0000Cooooo0_l00008
ooooo`Go00004Oooool005Wooooo00?o0000ooooool000004oooool3o`0006gooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Rooooo`00F_ooool2o`00013ooooo0ol0001`ooooo`03
o`000?oooooooooo01;ooooo0_l0000Sooooo`00Foooool00ol0003oooooooooo`0;ooooo`?o0000
Loooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo023ooooo001Vooooo`?o0000Mooo
ool00ol0003oooooooooo`0Cooooo`;o00008Oooool006?ooooo1?l0001iooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool07oooool0063ooooo0ol0001mooooo`03o`000?oooooooooo
01Cooooo0_l00007ooooo`?o00000oooool3o`00013ooooo001Nooooo`;o0000P?ooool00ol0003o
ooooooooo`0Dooooo`;o00002?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oo
oooo001Kooooo`?o0000P_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00?ooooo
1Ol00003ooooo`03o`000?oooooooooo00oooooo001Hooooo`Co0000Q?ooool00ol0003ooooooooo
o`0Fooooo`;o00001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001E
ooooo`?o00000oooool00ol0003oooooooooo`22ooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001Boooo
o`?o0000Roooool00ol0003oooooooooo`0Fooooo`?o00001?ooool2o`0000Cooooo0_l0000Aoooo
o`00;Oooool5o`0001gooooo0ol0002>ooooo`03o`000?oooooooooo01?ooooo0ol00002ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0?ooooo`00
;_ooool01?l0003oooooooooool0000Kooooo`;o000000?oooooo`000?ooool0S_ooool00ol0003o
ooooooooo`0@ooooo`?o00001Oooool00ol0003oooooooooo`0Kooooo`00;oooool00ol0003ooooo
ooooo`0Hooooo`?o0000Toooool00ol0003oooooooooo`0=ooooo`?o00002?ooool2o`0001cooooo
000`ooooo`03o`000?oooooooooo01Cooooo0ol0002Gooooo`03o`000?oooooooooo00Wooooo0ol0
000;ooooo`03o`000?oooooooooo01_ooooo000]ooooo`05o`000?ooooooooooooooool000004_oo
ool3o`0009[ooooo00?o0000ooooooooool01_ooool3o`0000oooooo00?o0000ooooooooool06_oo
ool002gooooo00Go0000ooooooooooooooooo`00000?ooooo`?o000000?oooooo`000?ooool0V_oo
ool00ol0003oooooooooo`03ooooo`?o00004_ooool00ol0003oooooooooo`0Jooooo`00;_ooool3
o`0000gooooo0ol0002Pooooo`03o`000?oooooooooo00?o00005?ooool2o`0001cooooo000loooo
o`;o0000Xoooool3o`0001Sooooo00?o0000ooooooooool06_ooool003Wooooo0ol0002Rooooo`Co
00006_ooool00ol0003oooooooooo`0Jooooo`00=_ooool3o`000003ooooool0003ooooo09oooooo
0ol00003ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool06_ooool003?ooooo0ol0
002Rooooo`?o00001_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Wooooo0_l0
0004ooooo`03o`000?oooooooooo00;ooooo0ol00003ooooo`00<?ooool3o`000:;ooooo0ol00009
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool0
0007ooooo`05o`000?ooooooooooooooool000000_ooool002gooooo1?l0002Pooooo`Co00003?oo
ool00ol0003oooooooooo`0Hooooo`;o00000_ooool5o`0000;ooooo00Co0000oooooooooooo0000
2oooool1o`00007ooooo0Oooool002[ooooo0ol00003ooooo`03o`000?oooooooooo09_ooooo0ol0
000@ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool01oooool01?l0003ooooooooo
ool0000;ooooo`7o00000Oooool1ooooo`00:?ooool2o`000:7ooooo0ol0000Dooooo`03o`000?oo
oooooooo01Sooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00007ooooo`Co0000
0oooool000Kooooo0_l0000Mooooo`?o0000X?ooool3o`0001Oooooo00?o0000ooooooooool05ooo
ool2o`0000Wooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`04ooooo`001Ooo
ool01?l0003oooooooooool0000Iooooo`Co0000Woooool3o`0001[ooooo00?o0000ooooooooool0
6?ooool00ol0003oooooooooo`08ooooo`;o00002?ooool5o`0000;ooooo0005ooooo`04o`000?oo
ooooooooo`0001Kooooo0ol0002Pooooo`?o00007Oooool00ol0003oooooooooo`0Hooooo`03o`00
0?oooooooooo01Wooooo0005ooooo`04o`000?ooooooooooo`0001?ooooo0ol0002Pooooo`?o0000
8?ooool00ol0003oooooooooo`0Hooooo`;o00006_ooool000Gooooo00Co0000oooooooooooo0000
4?ooool3o`000:3ooooo0ol0000Qooooo`?o00006_ooool00ol0003oooooooooo`0Iooooo`001Ooo
ool01?l0003oooooooooool0000>ooooo`;o00000_ooool00ol0003oooooooooo`2Kooooo`?o0000
8Oooool3o`0000;ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Iooooo`001_oo
ool2o`0000cooooo0ol0002Oooooo`?o00008Oooool3o`0000Kooooo00?o0000ooooooooool05ooo
ool2o`0001[ooooo000Aooooo`?o0000Woooool3o`00027ooooo0ol0000:ooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool06?ooool000kooooo1?l0002Nooooo`?o00008Oooool3o`00
00kooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Hooooo`002oooool3o`0009oo
oooo0ol0000Pooooo`Co00004Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo01So
oooo0008ooooo`?o0000W_ooool4o`00023ooooo0ol0000Fooooo`03o`000?oooooooooo01Cooooo
0_l0000Jooooo`001oooool2o`0009gooooo0ol0000Qooooo`?o00006_ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo00?ooooo0_l0000Cooooo`001oooool00ol0003oooooo`00002I
ooooo`?o00008Oooool3o`0001gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0001;ooooo0006ooooo`;o00000_ooool00ol0003oooooooooo`2C
ooooo`?o00008Oooool3o`00027ooooo00?o0000ooooooooool04oooool2o`0000?ooooo00Co0000
oooooooooooo00004_ooool000Oooooo00Go0000ooooooooooooooooo`00002Aooooo`?o00008Ooo
ool3o`0002Gooooo00?o0000ooooooooool04oooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooooooool04?ooool000Oooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`2;ooooo`?o00008?ooool4o`0002Wooooo00?o0000ooooooooool04_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00?o0000ooooooooool04?ooool000Oooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`27ooooo`?o00008?ooool3o`0002gooooo00?o0000ooooooooool03?oo
ool7o`0000?ooooo00Co0000oooooooooooo00004_ooool000Kooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`23ooooo`?o00008?ooool3o`00037ooooo00?o0000ooooooooool02?oo
ool3o`0000Kooooo00?o0000ooooooooool00_ooool2o`0001?ooooo0006ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0Ooooool3o`00023ooooo0ol0000eooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Gooooo`001_ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo07_ooooo0ol0000Pooooo`?o0000>?ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool05oooool000Ko
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1gooooo`?o00007oooool4o`0003co
oooo00Co0000oooooooooooooooo0ol0000;ooooo`03o`000?oooooooooo01Oooooo0006ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool0Loooool3o`0001oooooo0ol00011ooooo`03
o`000?oooooo000000kooooo00?o0000ooooooooool05oooool000Kooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`1_ooooo`?o00007oooool3o`0004Gooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`0Fooooo`001_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo06_ooooo0ol0000Oooooo`?o0000>Oooool4o`0000Wooooo0ol0000?ooooo`;o00006?oo
ool000Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`1Vooooo`Co00007oooool3
o`0003[ooooo0_l00004ooooo`Wo00000oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo01Kooooo0006ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0H_ooool3o`00
023ooooo0ol0000kooooo`;o00004oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
01Kooooo0005ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0G_ooool3o`0001oo
oooo1?l0000looooo`;o00005Oooool00ol0003oooooooooo`0;ooooo`;o00006?ooool000Gooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`1Jooooo`?o00007oooool3o`0003oooooo
00?o0000ooooooooool05_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Kooooo
0005ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0E_ooool3o`0001oooooo0ol0
0011ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`03ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool000Gooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`1Booooo`?o00007oooool3o`0004?ooooo00?o0000
ooooooooool06_ooool00ol0003oooooooooo`09ooooo`;o00000oooool01?l0003oooooooooool0
0007ooooo`05o`000?ooooooooooooooool000001?ooool000Gooooo00?o0000ooooooooool04ooo
ool2o`0004oooooo0ol0000Oooooo`?o0000=Oooool5o`0000_ooooo00?o0000ooooooooool06ooo
ool00ol0003oooooooooo`09ooooo`;o00000oooool01?l0003oooooooooool0000;ooooo`03o`00
0?oooooooooo00;ooooo0005ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0BOoo
ool3o`0001kooooo1?l0000fooooo`;o00001Oooool3o`0000Oooooo00?o0000ooooooooool07Ooo
ool00ol0003oooooooooo`09ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00;ooooo0005ooooo`03o`000?oooooooooo01Kooooo00?o
0000ooooooooool0AOooool3o`0001kooooo0ol0000iooooo`03o`000?oooooooooo00Sooooo1ol0
000Qooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooooooo00Gooooo1?l00005ooooo`001Oooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo047ooooo0ol0000Nooooo`?o0000??ooool00ol0003oooooooooo`0`ooooo`03o`000?oo
oooooooo00Kooooo0ol00003ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool0
1_ooool000Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0mooooo`?o00007_oo
ool3o`0003kooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00;ooooo0_l00008ooooo`Go00001?ooool000Cooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`0iooooo`?o00007_ooool3o`00043ooooo00?o0000ooooooooool0=?ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Gooooo0004ooooo`03o`000?oooooooooo
01_ooooo00?o0000ooooooooool0=Oooool3o`0001kooooo0ol0000`ooooo`;o00004?ooool00ol0
003oooooooooo`0fooooo`03o`000?oooooooooo00Cooooo0_l0000Gooooo`001?ooool00ol0003o
ooooooooo`0Looooo`03o`000?oooooooooo033ooooo1?l0000Mooooo`Co0000<_ooool00ol0003o
ooooooooo`03o`0000cooooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo01Gooooo0004ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0
;?ooool3o`0001kooooo0ol0000eooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
5Oooool000Cooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0Xooooo`?o00007_oo
ool3o`0003Oooooo00?o0000ooooooooool01_ooool2o`0000Oooooo00?o0000ooooooooool0>ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Cooooo0004ooooo`03o`000?oooooo
oooo01oooooo00?o0000ooooooooool09?ooool3o`0001kooooo0ol0000jooooo`03o`000?oooooo
oooo00Sooooo0_l00003ooooo`;o0000?_ooool00ol0003oooooooooo`03ooooo`;o00005_ooool0
00Cooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Pooooo`?o00007_ooool3o`00
03cooooo00?o0000ooooooooool02oooool3o`00047ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0Dooooo`001?ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo01co
oooo0ol0000Mooooo`Co0000:oooool4o`0000oooooo00?o0000ooooooooool0DOooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo01Cooooo0004ooooo`03o`000?oooooooooo02;ooooo
00?o0000ooooooooool06?ooool3o`0001gooooo0ol0000^ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`1Cooooo`03o`000?oooooooooo00;o0000
5_ooool000?ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Dooooo`?o00007Ooo
ool3o`00033ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo05Cooooo00Go0000ooooooooooooooooo`00000Fooooo`000oooool00ol0003ooooooooo
o`0Uooooo`03o`000?oooooooooo013ooooo0ol0000Mooooo`?o0000<_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0EOooool01?l0003ooooooooo
ool00004ooooo`?o00003oooool000?ooooo00?o0000ooooooooool09_ooool00ol0003ooooooooo
o`0<ooooo`?o00007Oooool3o`0002;ooooo0_l0000Aooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`1Gooooo`04o`000?oooooo0000o`0000Cooooo
00?o0000ooooooooool03_ooool000?ooooo00?o0000ooooooooool09oooool00ol0003ooooooooo
o`08ooooo`?o00007Oooool3o`0002?ooooo0_l00002ooooo`03o`000?oooooooooo00gooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo05Sooooo00Co
0000ooooool0003o00001?ooool00ol0003oooooooooo`0>ooooo`000oooool00ol0003ooooooooo
o`0Xooooo`03o`000?oooooooooo00Cooooo0ol0000Looooo`Co00009_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02Oooool2o`0000Gooooo00?o
0000ooooooooool0FOooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00kooooo0003
ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool00ol0000Looooo`?o0000:Oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`02o`0005gooooo0_l00004ooooo`03o`000?oooooooooo00kooooo0003oooo
o`03o`000?oooooooooo02[ooooo0_l0000Looooo`?o00006?ooool2o`0001;ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00gooooo0_l0001Noooo
o`?o00000oooool2o`00013ooooo0003ooooo`03o`000?oooooooooo02[ooooo00?o0000oooooooo
ool06?ooool3o`0001[ooooo00Co0000oooooooooooo00004?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0J_ooool3o`0000Oooooo00?o0000oooo
ooooool03_ooool000?ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0<ooooo`;o
00001oooool3o`0000Sooooo0_l0000Cooooo`04o`000?ooooooooooo`00013ooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo06Oooooo1?l0000Koooo
o`000_ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo00cooooo00?o0000ooooool0
00000_ooool4o`0000_ooooo00?o0000ooooool000004Oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo06Cooooo0ol0000Oooooo`000_ooool00ol0003oooooooooo`0[ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool00ol0000>ooooo`04o`000?ooooooooooo`00017o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Qooooo`Co00008_ooool000;ooooo
00?o0000ooooooooool0:oooool00ol0003oooooooooo`0;ooooo`Co00004?ooool01Ol0003ooooo
oooooooooooo000000oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Nooooo`?o
00009_ooool000;ooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`08ooooo`?o0000
0oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo05_ooooo1?l0000Yooooo`000_oo
ool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo00Gooooo0ol00002ooooo`05o`000?oo
ooooooooooooool000003oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`1Hooooo`?o0000;Oooool000;ooooo00?o
0000ooooooooool0:oooool00ol0003oooooooooo`02ooooo`?o00001Oooool01Ol0003ooooooooo
oooooooo000000oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0E_ooool3o`00033ooooo0002ooooo`03o`000?oo
oooooooo02[ooooo00?o0000ooooool000000ol00007ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00gooooo1?l0
001Eooooo`Co0000<oooool000;ooooo00?o0000ooooooooool0:Oooool3o`0000_ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool0Hoooool3o`0003Oooooo0002ooooo`03o`000?oooooooooo02Kooooo0ol000000ooo
oooo0000ooooo`0;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo05oooooo1?l0000jooooo`0000?oooooo`000?oo
ool09Oooool3o`0000Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Mooooo`?o
0000?_ooool00003ooooool0003ooooo02;ooooo0ol00007ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool0FOooool4o`00047ooooo00000ooooooo0000ooooo`0Nooooo`Co00002_oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo05Kooooo0ol00015ooooo`0000?ooooo
o`000?ooool06oooool3o`0000kooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1C
ooooo`Co0000B?ooool00003ooooool0003ooooo01Sooooo0ol0000Aooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0D?ooool3o`0004cooooo00000ooooooo0000ooooo`0Eooooo`?o
00005?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo04cooooo1?l0001?ooooo`00
00?oooooo`000?ooool04_ooool3o`0001Oooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00cooooo00Go0000ooooooooooooooooo`00001<ooooo`?o
0000Doooool00003ooooool0003ooooo00oooooo0ol0000Jooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0>ooooo`?o0000BOooool4o`0005Kooooo
00000ooooooo0000ooooo`0;ooooo`Co00007Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool0Eoooool3o`0005[ooooo00000ol0003oooooooooo`08
ooooo`?o00008Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool0Doooool4o`0005gooooo00000ol0003oooooooooo`05ooooo`?o00009?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0DOooool3o`00
067ooooo00000ol0003oooooooooo`02ooooo`?o00009oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0C_ooool3o`0006Cooooo00000ol0003ooooo
o`000002o`0002Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo04[ooooo1?l0001Wooooo`000_l0000/ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`18ooooo`?o0000Joooool000;ooooo00?o0000
ooooooooool0:Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0A?ooool4o`0006kooooo0003ooooo`03o`000?oooooooooo02Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo047ooooo0ol0001boooo
o`001?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00gooooo00Co0000oooooooo
oooo0000@?ooool4o`0007Gooooo0005ooooo`03o`000?oooooooooo02Kooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool03Oooool01?l0003oooooooooool0000mooooo`?o0000NOooool000Kooooo0_l0000Vooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00kooooo0_l0000jooooo`Co0000O?ooool000Sooooo00?o0000ooooooooool0
8oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`17ooooo`?o0000P?ooool000Wooooo00?o0000ooooooooool08_oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`14ooooo`Co0000Poooool000[ooooo00?o0000ooooooooool08Oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`11ooooo`?o0000Qoooool000_ooooo00?o0000ooooooooool08?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0mooooo`Co0000R_ooool000cooooo00?o0000ooooooooool07oooool2o`0000Oo
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03[o
oooo0ol0002>ooooo`003Oooool2o`0001oooooo0_l00007ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0fooooo`Co0000TOooool000oooooo00?o
0000ooooooooool07?ooool2o`0000Oooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo03Cooooo0ol0002Eooooo`004?ooool00ol0003oooooooooo`0K
ooooo`;o00001oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0<?ooool4o`0009Sooooo000Aooooo`03o`000?oooooooooo01[ooooo0_l00007oooo
o`03o`000?oooooooooo00cooooo00Go0000ooooooooooooooooo`00000_ooooo`?o0000W?ooool0
01;ooooo00?o0000ooooooooool06?ooool00ol0003oooooo`000007ooooo`03o`000?oooooooooo
00cooooo00Co0000oooooooooooo0000;Oooool3o`0009oooooo000Cooooo`;o00006?ooool00ol0
003oooooo`000007ooooo`03o`000?oooooooooo00cooooo00Co0000oooooooooooo0000:Oooool4
o`000:;ooooo000Eooooo`03o`000?oooooooooo01Gooooo00?o0000ooooool000001_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooo000002Kooooo0ol0002Vooooo`005_ooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooo000000Kooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`0Qooooo`Co0000ZOooool001Oooooo00?o0000ooooooooool04oooool00ol0003ooooo
o`000006ooooo`03o`000?oooooooooo033ooooo0ol0002]ooooo`006?ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool0;Oooool4o`000;3ooooo000I
ooooo`;o00004_ooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo02[ooooo0ol0002d
ooooo`006oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo000000Gooooo00?o0000oooo
ooooool09_ooool4o`000;Oooooo000Looooo`03o`000?oooooooooo00kooooo00?o0000ooooool0
00001Oooool00ol0003oooooooooo`0Sooooo`?o0000^oooool001gooooo00?o0000ooooooooool0
3Oooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo01oooooo1?l0002nooooo`007_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool07Ooo
ool3o`000<;ooooo000Oooooo`;o00003?ooool01?l0003oooooooooool00003ooooo`03o`000?oo
oooooooo01Wooooo1?l00035ooooo`008Oooool00ol0003oooooooooo`09ooooo`04o`000?oooooo
ooooo`0000?ooooo00?o0000ooooooooool05_ooool3o`000<Wooooo000Rooooo`03o`000?oooooo
oooo00Sooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0Booooo`Co0000c?oo
ool002?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo013ooooo0ol0003@ooooo`009?ooool00ol0003oooooooooo`05ooooo`05o`000?oooooo
ooooooooool000000_ooool00ol0003oooooooooo`0=ooooo`?o0000doooool002Gooooo00?o0000
ooooooooool01?ooool01ol0003ooooooooooooooooo0000ooooool000003?ooool4o`000=Kooooo
000Vooooo`;o00001?ooool01ol0003ooooooooooooooooo0000ooooool000002Oooool3o`000=[o
oooo000Xooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`04ooooo`Co
0000gOooool002Wooooo00Co0000oooooooooooo00002?ooool3o`000>7ooooo000Zooooo`03o`00
0?oooooo000000Cooooo1?l0003Tooooo`00:oooool2o`000004ooooool0003o0000o`000>Sooooo
000/ooooo`;o0000joooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.875}, {190.438, 0}} -> {0.0219893, 0.106871, \
0.00376814, 0.00376814}}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Presentation as a Space Curve"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p4 = 
        ParametricPlot3D[{t, E\^\(-\(t\/3\)\)\ Cos[6\ t], 
            E\^\(-\(t\/3\)\)\ Sin[6\ t]}, {t, 0, 3\ \[Pi],  .05}, 
          Boxed \[Rule] True, 
          PlotRange \[Rule] {{0, 3\ \[Pi]}, {\(-1\), 1}, {\(-1\), 1}}, 
          BoxRatios \[Rule] {3, 1, 1}];\)\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .67912 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0224888 1.02249 -0.150431 1.02249 [
[.02846 .27668 -2.67377 -9 ]
[.02846 .27668 3.32623 0 ]
[.18704 .22058 -2.78329 -9 ]
[.18704 .22058 3.21671 0 ]
[.35321 .1618 -2.90126 -9 ]
[.35321 .1618 3.09874 0 ]
[.52756 .10014 -3.0287 -9 ]
[.52756 .10014 2.9713 0 ]
[.71068 .0354 -3.1668 -9 ]
[.71068 .0354 2.8332 0 ]
[.86008 -0.00425 0 -6.08625 ]
[.86008 -0.00425 12 2.91375 ]
[.8924 .04484 0 -6.05064 ]
[.8924 .04484 24 2.94936 ]
[.92355 .09216 0 -6.0166 ]
[.92355 .09216 6 2.9834 ]
[.9536 .13781 0 -5.98402 ]
[.9536 .13781 18 3.01598 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 6 3.04719 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 12 3.04719 ]
[.9897 .2427 0 -5.91612 ]
[.9897 .2427 24 3.08388 ]
[.99701 .30533 0 -5.87841 ]
[.99701 .30533 6 3.12159 ]
[1.00453 .36986 0 -5.83963 ]
[1.00453 .36986 18 3.16037 ]
[1.01228 .43637 0 -5.79975 ]
[1.01228 .43637 6 3.20025 ]
[ 0 0 0 0 ]
[ 1 .67912 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.84803 0 m
.842 .00212 L
s
[(-1)] .86008 -0.00425 -1 .3525 Mshowa
.88031 .049 m
.87427 .05108 L
s
[(-0.5)] .8924 .04484 -1 .34459 Mshowa
.91144 .09624 m
.90538 .09828 L
s
[(0)] .92355 .09216 -1 .33702 Mshowa
.94146 .14181 m
.93539 .14381 L
s
[(0.5)] .9536 .13781 -1 .32978 Mshowa
.97045 .1858 m
.96437 .18777 L
s
[(1)] .98261 .18188 -1 .32285 Mshowa
.125 Mabswid
.85458 .00995 m
.85096 .01122 L
s
.86108 .01982 m
.85746 .02108 L
s
.86754 .02962 m
.86392 .03088 L
s
.87395 .03934 m
.87033 .0406 L
s
.88663 .05859 m
.883 .05983 L
s
.8929 .0681 m
.88927 .06934 L
s
.89912 .07755 m
.89549 .07878 L
s
.9053 .08693 m
.90167 .08816 L
s
.91753 .10548 m
.91389 .1067 L
s
.92358 .11466 m
.91994 .11588 L
s
.92958 .12378 m
.92594 .12499 L
s
.93554 .13283 m
.9319 .13403 L
s
.94734 .15073 m
.9437 .15193 L
s
.95318 .15959 m
.94953 .16078 L
s
.95898 .16839 m
.95533 .16958 L
s
.96473 .17713 m
.96108 .17831 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
.25 Mabswid
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
.18827 .43833 m
.02708 .28938 L
s
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.18827 .43833 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
0 0 m
1 0 L
1 .67912 L
0 .67912 L
closepath
clip
newpath
.5 Mabswid
.18026 .55551 m
.17694 .58558 L
s
.17694 .58558 m
.16736 .60638 L
s
.21367 .42943 m
.22683 .45861 L
s
.19639 .40212 m
.21367 .42943 L
s
.22683 .45861 m
.23528 .48715 L
s
.17591 .37917 m
.19639 .40212 L
s
.23528 .48715 m
.23879 .51261 L
s
.15347 .36286 m
.17591 .37917 L
s
.23879 .51261 m
.23749 .53283 L
s
.16736 .60638 m
.15271 .616 L
s
.13054 .35509 m
.15347 .36286 L
s
.23749 .53283 m
.23192 .54603 L
s
.28573 .41449 m
.29609 .43515 L
s
.27249 .39495 m
.28573 .41449 L
s
.29609 .43515 m
.30316 .45507 L
s
.25703 .37838 m
.27249 .39495 L
s
.10877 .35721 m
.13054 .35509 L
s
.15271 .616 m
.13461 .61343 L
s
.30316 .45507 m
.30678 .47248 L
s
.24023 .36645 m
.25703 .37838 L
s
.23192 .54603 m
.22293 .55102 L
s
.30678 .47248 m
.30708 .48585 L
s
.22312 .36057 m
.24023 .36645 L
s
.0899 .36977 m
.10877 .35721 L
s
.30708 .48585 m
.30445 .49398 L
s
.20687 .36169 m
.22312 .36057 L
s
.13461 .61343 m
.11509 .59877 L
s
.22293 .55102 m
.21172 .54727 L
s
.36367 .39466 m
.37215 .4091 L
s
.35319 .38085 m
.36367 .39466 L
s
.34118 .36902 m
.35319 .38085 L
s
.37215 .4091 m
.37835 .4228 L
s
.32825 .36041 m
.34118 .36902 L
s
.07551 .39236 m
.0899 .36977 L
s
.30445 .49398 m
.29954 .49612 L
s
.19263 .37024 m
.20687 .36169 L
s
.37835 .4228 m
.38216 .43451 L
s
.31514 .35605 m
.32825 .36041 L
s
.21172 .54727 m
.19969 .53509 L
s
.38216 .43451 m
.38369 .44315 L
s
.11509 .59877 m
.09636 .57331 L
s
.29954 .49612 m
.29317 .49203 L
s
.30263 .35666 m
.31514 .35605 L
s
.18146 .38593 m
.19263 .37024 L
s
.06692 .42353 m
.07551 .39236 L
s
.38369 .44315 m
.38322 .4479 L
s
.19969 .53509 m
.18835 .51559 L
s
.29152 .36254 m
.30263 .35666 L
s
.29317 .49203 m
.28632 .48207 L
s
.17423 .40777 m
.18146 .38593 L
s
.09636 .57331 m
.08061 .5395 L
s
.38322 .4479 m
.3812 .44832 L
s
.43791 .36167 m
.44652 .37127 L
s
.42824 .35336 m
.43791 .36167 L
s
.44652 .37127 m
.45376 .38119 L
s
.41796 .34727 m
.42824 .35336 L
s
.45376 .38119 m
.45942 .39045 L
s
.06493 .46077 m
.06692 .42353 L
s
.28251 .37353 m
.29152 .36254 L
s
.18835 .51559 m
.17912 .49061 L
s
.40756 .34416 m
.41796 .34727 L
s
.45942 .39045 m
.46345 .39814 L
s
.17145 .43406 m
.17423 .40777 L
s
.28632 .48207 m
.28 .46713 L
s
.3812 .44832 m
.37823 .44431 L
s
.08061 .5395 m
.0697 .50071 L
s
.39758 .34455 m
.40756 .34416 L
s
.46345 .39814 m
.4659 .40351 L
s
.27618 .38896 m
.28251 .37353 L
s
.0697 .50071 m
.06493 .46077 L
s
.17912 .49061 m
.1732 .46255 L
s
.1732 .46255 m
.17145 .43406 L
s
.38858 .3487 m
.39758 .34455 L
s
.28 .46713 m
.27517 .44859 L
s
.37823 .44431 m
.37496 .43621 L
s
.4659 .40351 m
.46699 .40603 L
s
.27286 .40769 m
.27618 .38896 L
s
.27517 .44859 m
.2726 .42816 L
s
.2726 .42816 m
.27286 .40769 L
s
.38102 .35651 m
.38858 .3487 L
s
.46699 .40603 m
.46704 .40541 L
s
.37496 .43621 m
.37209 .42472 L
s
.37528 .36754 m
.38102 .35651 L
s
.52622 .33873 m
.53359 .34526 L
s
.51813 .33304 m
.52622 .33873 L
s
.53359 .34526 m
.54002 .35191 L
s
.50963 .32887 m
.51813 .33304 L
s
.37209 .42472 m
.37025 .41087 L
s
.46704 .40541 m
.46645 .40166 L
s
.54002 .35191 m
.54537 .35799 L
s
.50105 .32677 m
.50963 .32887 L
s
.37158 .38101 m
.37528 .36754 L
s
.37025 .41087 m
.36996 .39587 L
s
.54537 .35799 m
.5496 .36285 L
s
.36996 .39587 m
.37158 .38101 L
s
.49279 .32714 m
.50105 .32677 L
s
.46645 .40166 m
.46568 .39507 L
s
.5496 .36285 m
.55276 .36597 L
s
.48519 .33018 m
.49279 .32714 L
s
.47858 .33585 m
.48519 .33018 L
s
.46568 .39507 m
.46519 .38617 L
s
.55276 .36597 m
.55498 .36701 L
s
.47322 .34386 m
.47858 .33585 L
s
.46519 .38617 m
.4654 .37572 L
s
.55498 .36701 m
.5565 .3658 L
s
.46924 .35368 m
.47322 .34386 L
s
.4654 .37572 m
.46667 .36458 L
s
.46667 .36458 m
.46924 .35368 L
s
.5565 .3658 m
.55759 .36237 L
s
.61783 .31296 m
.62439 .31724 L
s
.61079 .30922 m
.61783 .31296 L
s
.60347 .3065 m
.61079 .30922 L
s
.62439 .31724 m
.63031 .32153 L
s
.59611 .30521 m
.60347 .3065 L
s
.55759 .36237 m
.55856 .35697 L
s
.63031 .32153 m
.6355 .32534 L
s
.58898 .30567 m
.59611 .30521 L
s
.6355 .32534 m
.63992 .32821 L
s
.5823 .30802 m
.58898 .30567 L
s
.55856 .35697 m
.55973 .35 L
s
.57631 .31227 m
.5823 .30802 L
s
.63992 .32821 m
.64361 .3298 L
s
.55973 .35 m
.56137 .34201 L
s
.57117 .31821 m
.57631 .31227 L
s
.56698 .32549 m
.57117 .31821 L
s
.56137 .34201 m
.56374 .33363 L
s
.64361 .3298 m
.64667 .32987 L
s
.56374 .33363 m
.56698 .32549 L
s
.64667 .32987 m
.64924 .32832 L
s
.64924 .32832 m
.65153 .3252 L
s
.65153 .3252 m
.65373 .32072 L
s
.7062 .28268 m
.71257 .28499 L
s
.69966 .28107 m
.7062 .28268 L
s
.71257 .28499 m
.71862 .28762 L
s
.69309 .28044 m
.69966 .28107 L
s
.68669 .28104 m
.69309 .28044 L
s
.71862 .28762 m
.72423 .29021 L
s
.65373 .32072 m
.65606 .31517 L
s
.68061 .28299 m
.68669 .28104 L
s
.72423 .29021 m
.72935 .29241 L
s
.65606 .31517 m
.65871 .30896 L
s
.675 .28629 m
.68061 .28299 L
s
.72935 .29241 m
.73395 .29389 L
s
.66997 .29082 m
.675 .28629 L
s
.65871 .30896 m
.66185 .30254 L
s
.66559 .29635 m
.66997 .29082 L
s
.66185 .30254 m
.66559 .29635 L
s
.73395 .29389 m
.73805 .29442 L
s
.73805 .29442 m
.74172 .29384 L
s
.74172 .29384 m
.74506 .29211 L
s
.74506 .29211 m
.7482 .28928 L
s
.7482 .28928 m
.75128 .28549 L
s
.75128 .28549 m
.75445 .28099 L
s
.75445 .28099 m
.75783 .27606 L
s
.79832 .25323 m
.80438 .254 L
s
.79226 .25313 m
.79832 .25323 L
s
.80438 .254 m
.81033 .25524 L
s
.78631 .25389 m
.79226 .25313 L
s
.81033 .25524 m
.81607 .25667 L
s
.78059 .25561 m
.78631 .25389 L
s
.75783 .27606 m
.76154 .27102 L
s
.7752 .25829 m
.78059 .25561 L
s
.81607 .25667 m
.82152 .25803 L
s
.77021 .26188 m
.7752 .25829 L
s
.76154 .27102 m
.76566 .2662 L
s
.76566 .2662 m
.77021 .26188 L
s
.82152 .25803 m
.82663 .25908 L
s
.82663 .25908 m
.8314 .25958 L
s
.8314 .25958 m
.83582 .25938 L
s
.83582 .25938 m
.83996 .25838 L
s
.83996 .25838 m
.84386 .25656 L
s
.84386 .25656 m
.84763 .25396 L
s
.84763 .25396 m
.85136 .2507 L
s
.85136 .2507 m
.85514 .24696 L
s
.85514 .24696 m
.85906 .24294 L
s
.85906 .24294 m
.8632 .23888 L
s
.8632 .23888 m
.86762 .23501 L
s
.86762 .23501 m
.87233 .23151 L
s
.89383 .22374 m
.8996 .22341 L
s
.88815 .22467 m
.89383 .22374 L
s
.88263 .22627 m
.88815 .22467 L
s
.87734 .22857 m
.88263 .22627 L
s
.8996 .22341 m
.90537 .22355 L
s
.87233 .23151 m
.87734 .22857 L
s
.90537 .22355 m
.91108 .22399 L
s
.91108 .22399 m
.91664 .22454 L
s
.91664 .22454 m
.92202 .22502 L
s
.92202 .22502 m
.92718 .22524 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.875, 191.438},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000_b000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00i_ooool3
o`00033ooooo003Wooooo`03o`000?oooooooooo02oooooo003Oooooo`Go00000oooool00ol0003o
ooooooooo`0_ooooo`00ioooool00ol0003oooooooooo`0_ooooo`00ioooool00ol0003ooooooooo
o`0_ooooo`00i_ooool2o`00037ooooo003Jooooo`?o00002_ooool00ol0003oooooooooo`0_oooo
o`00]_ooool3o`0001oooooo0ol000000ooooooo0000ooooo`0kooooo`00]Oooool01Ol0003ooooo
oooooooooooo000001_ooooo0ol00004ooooo`;o0000>oooool00;Gooooo00Go0000oooooooooooo
ooooo`00000Hooooo`?o00001oooool00ol0003oooooo`00000jooooo`00]_ooool3o`0001Kooooo
0ol0000:ooooo`03o`000?oooooo000003[ooooo002eooooo`05o`000?ooooooooooooooool00000
4_ooool3o`0000;ooooo00?o0000ooooooooool02?ooool01?l0003oooooo`000?l0000iooooo`00
]Oooool01Ol0003ooooooooooooooooo0000013ooooo0_l0000@ooooo`05o`000?oooooooooooooo
ool00000>?ooool00;Kooooo0ol0000>ooooo`?o00004oooool00ol0003oooooooooo`02o`0000go
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000Looooo`00a?ooool3o`0001Kooooo
00?o0000ooooooooool00_l0000<ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooo
ooooooooo`00000Kooooo`00`Oooool3o`000003ooooool0003ooooo01Kooooo00Go0000oooooooo
ooooooooo`000005ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooo
oooo01Wooooo002nooooo`?o00007?ooool01?l0003oooooooooooooool2o`0000_ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`0Iooooo`00^oooool3o`0001oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo1?l0
000Looooo`00^?ooool3o`0002;ooooo00?o0000ooooooooool00oooool2o`0000Wooooo00Co0000
oooooooooooo00001oooool00ol0003oooooooooo`0Mooooo`00]_ooool3o`0002Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooo`00000:ooooo`;o00002?ooool5o`0001_ooooo002coooo
o`?o00000_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0<Oooool00;3ooooo0ol0000Zooooo`03o`000?oooooooooo00Gooooo0_l0000booooo`00
[Oooool3o`0002gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0`ooooo`00Z_oo
ool3o`00033ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0_ooooo`00Q_ooool3
o`0001kooooo0ol00002ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool01Oooool2
o`00037ooooo0025ooooo`05o`000?ooooooooooooooool000006oooool2o`0003Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`06ooooo`;o00009_ooool008Gooooo00Go0000oooo
ooooooooooooo`00000Hooooo`?o0000>Oooool00ol0003oooooooooo`07ooooo`;o00001_ooool0
1?l0003oooooooooool0000Uooooo`00QOooool4o`0001Kooooo0ol0000looooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000Uooooo`00QOooool0
0ol0003oooooooooo`0Dooooo`?o000000?oooooo`000?ooool0??ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00009Oooool008Kooooo00?o0000
ooooooooool04?ooool3o`0004;ooooo00?o0000ooooooooool02Oooool2o`0000Cooooo00Co0000
oooooooooooo00009Oooool008Oooooo0_l0000=ooooo`?o0000AOooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00009Oooool009Cooooo0_l00018
ooooo`03o`000?oooooooooo00Wooooo0ol00004ooooo`;o00009_ooool0097ooooo1?l00019oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0:_ooool008kooooo0ol0001=ooooo`03
o`000?oooooooooo00cooooo0_l0000Zooooo`00Roooool3o`00053ooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`0Xooooo`00R?ooool3o`0005Cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Xooooo`00QOooool4o`0005Kooooo00?o0000ooooooooool03?ooool2
o`0002Wooooo0023ooooo`;o00000oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool01_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`00
01;ooooo0020ooooo`?o0000G?ooool00ol0003oooooooooo`0>ooooo`;o00001_ooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000004Oooool007gooooo0ol0001Ooooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00oooooo001Jooooo`?o00007Oooool4o`00067ooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000
ooooooooool03oooool005_ooooo00?o0000ooooooooool06Oooool3o`0006Gooooo00?o0000oooo
ooooool03oooool2o`0000Gooooo00Co0000oooooooooooo00001oooool4o`0001;ooooo001Hoooo
o`Go00005oooool3o`0006Sooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool04oooool005Sooooo00Co0000oooo
oooooooo00005Oooool3o`0006_ooooo00?o0000ooooooooool04?ooool3o`0000Cooooo0_l00008
ooooo`Go00004Oooool005Wooooo00?o0000ooooool000004oooool3o`0006gooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Rooooo`00F_ooool2o`00013ooooo0ol0001`ooooo`03
o`000?oooooooooo01;ooooo0_l0000Sooooo`00Foooool00ol0003oooooooooo`0;ooooo`?o0000
Loooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo023ooooo001Vooooo`?o0000Mooo
ool00ol0003oooooooooo`0Cooooo`;o00008Oooool006?ooooo1?l0001iooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool07oooool0063ooooo0ol0001mooooo`03o`000?oooooooooo
01Cooooo0_l00007ooooo`?o00000oooool3o`00013ooooo001Nooooo`;o0000P?ooool00ol0003o
ooooooooo`0Dooooo`;o00002?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oo
oooo001Kooooo`?o0000P_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00?ooooo
1Ol00003ooooo`03o`000?oooooooooo00oooooo001Hooooo`Co0000Q?ooool00ol0003ooooooooo
o`0Fooooo`;o00001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001E
ooooo`?o00000oooool00ol0003oooooooooo`22ooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001Boooo
o`?o0000Roooool00ol0003oooooooooo`0Fooooo`?o00001?ooool2o`0000Cooooo0_l0000Aoooo
o`00;Oooool5o`0001gooooo0ol0002>ooooo`03o`000?oooooooooo01?ooooo0ol00002ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0?ooooo`00
;_ooool01?l0003oooooooooool0000Kooooo`;o000000?oooooo`000?ooool0S_ooool00ol0003o
ooooooooo`0@ooooo`?o00001Oooool00ol0003oooooooooo`0Kooooo`00;oooool00ol0003ooooo
ooooo`0Hooooo`?o0000Toooool00ol0003oooooooooo`0=ooooo`?o00002?ooool2o`0001cooooo
000`ooooo`03o`000?oooooooooo01Cooooo0ol0002Gooooo`03o`000?oooooooooo00Wooooo0ol0
000;ooooo`03o`000?oooooooooo01_ooooo000]ooooo`05o`000?ooooooooooooooool000004_oo
ool3o`0009[ooooo00?o0000ooooooooool01_ooool3o`0000oooooo00?o0000ooooooooool06_oo
ool002gooooo00Go0000ooooooooooooooooo`00000?ooooo`?o000000?oooooo`000?ooool0V_oo
ool00ol0003oooooooooo`03ooooo`?o00004_ooool00ol0003oooooooooo`0Jooooo`00;_ooool3
o`0000gooooo0ol0002Pooooo`03o`000?oooooooooo00?o00005?ooool2o`0001cooooo000loooo
o`;o0000Xoooool3o`0001Sooooo00?o0000ooooooooool06_ooool003Wooooo0ol0002Rooooo`Co
00006_ooool00ol0003oooooooooo`0Jooooo`00=_ooool3o`000003ooooool0003ooooo09oooooo
0ol00003ooooo`03o`000?oooooooooo00go00002oooool00ol0003oooooooooo`0Jooooo`00<ooo
ool3o`000:;ooooo0ol00006ooooo`03o`000?oooooo000001Sooooo00?o0000ooooooooool02Ooo
ool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000?ooooo000`ooooo`?o0000X_ooool3
o`0000Wooooo0_l0000Iooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo00001ooo
ool01Ol0003ooooooooooooooooo000000;ooooo000]ooooo`Co0000X?ooool4o`0000cooooo00?o
0000ooooooooool06?ooool2o`0000;ooooo1Ol00002ooooo`04o`000?ooooooooooo`0000_ooooo
0Ol00001ooooo`7ooooo000Zooooo`?o00000oooool00ol0003oooooooooo`2Kooooo`?o00003_oo
ool3o`0001_ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool0000;ooooo`7o0000
0Oooool1ooooo`00:?ooool2o`000:7ooooo0ol0000@ooooo`05o`000?ooooooooooooooool00000
6_ooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000Oooooo1?l00003ooooo`00
1_ooool2o`0001gooooo0ol0002Pooooo`?o00004_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo01Oooooo0_l00009ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooooooo
ool01?ooool000Gooooo00Co0000oooooooooooo00006Oooool4o`0009oooooo0ol00005ooooo`?o
00003?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool02?ooool2o`0000Sooooo1Ol00002ooooo`001Oooool01?l0003oooooooooool0000Fooooo`?o
0000X?ooool3o`0000Gooooo0ol00003ooooo`Go00001_ooool2o`0000Gooooo00?o0000oooooooo
ool06?ooool00ol0003oooooooooo`0Iooooo`001Oooool01?l0003oooooooooool0000Cooooo`?o
0000X?ooool3o`0000Kooooo0_l0000;ooooo`Ko00001oooool00ol0003oooooooooo`0Hooooo`;o
00006_ooool000Gooooo00Co0000oooooooooooo00004?ooool3o`000:3ooooo0ol00008ooooo`03
o`000?oooooooooo01Kooooo0ol0000Jooooo`03o`000?oooooooooo01Wooooo0005ooooo`04o`00
0?ooooooooooo`0000kooooo0_l00002ooooo`03o`000?oooooooooo09_ooooo0ol0000:ooooo`03
o`000?oooooooooo01Cooooo0ol00002ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool06Oooool000Kooooo0_l0000<ooooo`?o0000Woooool3o`0000cooooo00?o0000ooooooooool0
4_ooool3o`0000Kooooo00?o0000ooooooooool05oooool2o`0001[ooooo000Aooooo`?o0000Wooo
ool3o`0000kooooo00?o0000ooooooooool04?ooool3o`0000[ooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`0Hooooo`003_ooool4o`0009kooooo0ol0000Aooooo`03o`000?oooooo
oooo00gooooo0ol0000>ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool06?ooool0
00_ooooo0ol0002Oooooo`_o00002oooool00ol0003oooooooooo`0:ooooo`Co00004Oooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooooooo01Sooooo0008ooooo`?o0000W_ooool4o`000003
ooooool0003o000000Sooooo0ol00007ooooo`03o`000?oooooooooo00Sooooo0ol0000Fooooo`03
o`000?oooooooooo01Cooooo0_l0000Jooooo`001oooool2o`0009gooooo0ol00004ooooo`03o`00
0?oooooooooo00_ooooo0_l00005ooooo`03o`000?oooooooooo00Gooooo0ol0000Jooooo`03o`00
0?oooooooooo01Cooooo00?o0000ooooooooool00oooool2o`0001?ooooo0007ooooo`03o`000?oo
oooo000009Wooooo0ol00007ooooo`03o`000?oooooooooo00gooooo1Ol00005ooooo`?o00007Ooo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000
4_ooool000Kooooo0_l00002ooooo`03o`000?oooooooooo09?ooooo0ol00009ooooo`03o`000?oo
oooooooo01Gooooo0ol0000Qooooo`03o`000?oooooooooo01?ooooo0_l00003ooooo`04o`000?oo
ooooooooo`0001;ooooo0007ooooo`05o`000?ooooooooooooooool00000TOooool3o`0000_ooooo
00?o0000ooooooooool04oooool3o`0002Gooooo00?o0000ooooooooool04oooool01Ol0003ooooo
oooooooooooo000000;ooooo00?o0000ooooooooool04?ooool000Oooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`29ooooo`Ko00003Oooool00ol0003oooooooooo`0?ooooo`Co0000
:Oooool00ol0003oooooooooo`0Booooo`05o`000?ooooooooooooooool000000_ooool00ol0003o
ooooooooo`0@ooooo`001oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo08Kooooo
1?l00004ooooo`;o00002_ooool00ol0003oooooooooo`0=ooooo`?o0000;Oooool00ol0003ooooo
ooooo`0Aooooo`;o00000oooool01?l0003oooooooooool0000Booooo`001_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo08?ooooo0ol00009ooooo`;o00002?ooool00ol0003ooooo
ooooo`0:ooooo`?o0000<Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00;ooooo
0_l0000Cooooo`001_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo07oooooo1?l0
000=ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01oooool3o`0003Gooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0Gooooo`001_ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo07_ooooo0ol00003ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`05ooooo`?o0000>?ooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo01Oooooo0006ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool0Moooool3o`0000Gooooo00?o0000ooooooooool03_ooool2o`0000?ooooo00Co0000oooo
oooooooooooo1?l0000looooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool05oooool0
00Kooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`1Xooooo`Wo00000_ooool3o`00
00Sooooo00?o0000ooooooooool04?ooool3o`000004ooooool0003o0000o`00047ooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0Gooooo`001_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo06Oooooo00?o0000ooooooooool01Oooool3o`0000[ooooo00?o0000oooo
ooooool04_ooool3o`0004Gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Foooo
o`001_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo06Gooooo00?o0000oooooooo
ool00oooool3o`0000;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0?ooooo`?o
0000B?ooool00ol0003oooooooooo`0=ooooo`;o00006?ooool000Kooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo00Co00001_ooool2o`0000Oooooo
00?o0000ooooooooool03Oooool3o`0004cooooo00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`0Fooooo`001_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo04gooooo1_l0
000>ooooo`Co00003?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00[ooooo0ol0
001@ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05_ooool000Gooooo00?o0000
ooooooooool03oooool00ol0003oooooooooo`1:ooooo`;o00001_ooool3o`0000Wooooo0ol0000@
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool4o`0005?ooooo00?o0000
ooooooooool02oooool2o`0001Sooooo0005ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool0B?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?ooooo0ol000000ooo
oooo0000ooooo`0Aooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool3o`00
05Sooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Fooooo`001Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooo000000So0000:Oooool7o`0000kooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`03o`0000Cooooo00?o0000ooooooooool04?ooool01Ol0003o
oooooooooooooooo000000?ooooo0ol0001Looooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool00oooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo0005ooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool01oooool3o`00013ooooo1?l0000Aooooo`03
o`000?oooooooooo00Gooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo0ol00007ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool01?l0001Pooooo`03o`000?oooooooooo00Wo
oooo0_l00003ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004
ooooo`001Oooool00ol0003oooooooooo`0Aooooo`04o`000?oooooo0000o`0000[ooooo0_l0000;
ooooo`?o00001?ooool3o`0000gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Sooooo0ol00002ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool04_ooool3o`0006?ooooo00?o0000ooooooooool02Oooool2o`0000?ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`02ooooo`001Oooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`06
ooooo`;o00002_ooool2o`0000_ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Gooooo0ol00006ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool03_ooool4o`000003ooooool0003o000006Cooooo00?o0000ooooooooool02Oooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`02ooooo`001Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool02Oooool2o`0000Gooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02
ooooo`?o00002_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00cooooo0ol0001/
ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooooooo00Gooooo1?l00005ooooo`001Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooool000000_l0000=ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool02Oooool3o`0006oooooo00?o0000ooooooooool01_ooool3o`0000?ooooo00Co0000
oooooooooooo00001oooool00ol0003oooooooooo`06ooooo`001Oooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02_ooool01?l0003oooooooooool0
000Aooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`03ooooo`?o00004Oooool01Ol0003ooooooooooooooooo000000Sooooo0ol0001cooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool00_ooool2o`0000Sooooo1Ol00004ooooo`001?oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Ooo
ool01?l0003oooooooooool0000Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
4?ooool00ol0003oooooo`000003o`0001Cooooo00Co0000oooooooooooo00001Oooool3o`0007Oo
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Eooooo`001?ooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool2o`0001Cooooo
00Go0000ooooooooooooooooo`00000Aooooo`?o00000oooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooo000000;ooooo0ol0001kooooo`03o`000?oooooooooo00Cooooo0_l0000Gooooo`00
1?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo000000kooooo1?l00003ooooo`04o`00
0?ooooooooooo`0001Kooooo1?l0001nooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool05Oooool000Cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooool000005Oooool2o`0000_ooooo0ol00008ooooo`03o`00
0?oooooo000001?ooooo1Ol00021ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
5Oooool000Cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00Kooooo00Co0000oooooooooooo00005?ooool2o`0000Sooooo0ol0000;ooooo`03o`00
0?oooooo0000013ooooo0ol00004ooooo`03o`000?oooooooooo083ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0Dooooo`001?ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000001?ooooo
0_l00005ooooo`?o00003oooool2o`0000gooooo0ol00007ooooo`;o0000POooool00ol0003ooooo
ooooo`03ooooo`;o00005_ooool000Cooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0Aooooo`04o`000?oooooo0000ooooo`?o00004_ooool2o`0000[ooooo0ol0000;ooooo`03o`00
0?oooooooooo083ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Dooooo`001?oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo013ooooo1?l0000Fooooo`03o`000?oo
oooooooo00Cooooo1?l0002Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05?oo
ool000Cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Dooooo`05o`000?oooooo
ooooooooool000001_ooool00ol0003oooooooooo`0=ooooo`?o00000oooool00ol0003ooooooooo
o`0Cooooo`04o`000?ooooooooooooooo`?o0000Uoooool00ol0003oooooooooo`02o`0001Kooooo
0003ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05Oooool01?l0003ooooooooo
ool00007ooooo`03o`000?oooooooooo00Wooooo0ol00002ooooo`05o`000?ooooooooooooooool0
00005Oooool4o`0009[ooooo00Go0000ooooooooooooooooo`00000Fooooo`000oooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooool000001oooool00ol0003o
ooooooooo`06ooooo`?o00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo013o
oooo0ol000000ooooooo0000ooooo`2Kooooo`04o`000?ooooooooooo`0000Cooooo0ol0000?oooo
o`000oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`02ooooo`?o00002?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00gooooo0ol00002ooooo`03o`000?oooooo000009gooooo00Co0000ooooool0
003o00001?ooool00ol0003oooooooooo`0>ooooo`000oooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo01Sooooo0_l00009ooooo`Co00002oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00[ooooo0ol00005ooooo`03o`000?oooooo000009gooooo00Co0000ooooool0
003o00001?ooool00ol0003oooooooooo`0>ooooo`000oooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooool000001_ooool3o`0000kooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`05ooooo`Co00002Oooool00ol0003oooooo`00002Mooooo`03
o`000?oooooo000000Cooooo00?o0000ooooooooool03_ooool000?ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Hooooo`04o`000?ooooooooooo`0000;ooooo0ol00003ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`?o
00003Oooool00ol0003oooooo`00002Nooooo`;o00001?ooool00ol0003oooooooooo`0>ooooo`00
0oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Sooooo00Co0000oooooooooooo
oooo0_l00006ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooo`000002o`00013ooooo00?o0000ooooool00000WOooool3o`0000?ooooo0_l0000@ooooo`00
0oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Wooooo00Go0000oooooooooooo
ooooo`000007ooooo`03o`000?oooooooooo00cooooo00Co0000oooooooooooooooo0ol0000Doooo
o`;o0000V_ooool3o`0000Oooooo00?o0000ooooooooool03_ooool000?ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0Iooooo`05o`000?ooooooooooooooool000002?ooool00ol0
003oooooooooo`0;ooooo`Co00000_ooool00ol0003oooooooooo`0Booooo`;o0000U_ooool4o`00
01_ooooo0002ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool06Oooool01Ol0003o
oooooooooooooooo000000Sooooo00?o0000ooooooooool02?ooool4o`0000Gooooo00?o0000oooo
ooooool0Yoooool3o`0001oooooo0002ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool06Oooool01Ol0003ooooooooooooooooo000000Sooooo00?o0000ooooooooool01Oooool3o`00
00?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`2Rooooo`Co00008_ooool000;o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Iooooo`05o`000?oooooooooooooo
ool000002Oooool01?l0003oooooooooooooool3o`0000Oooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`2Oooooo`?o00009_ooool000;ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Iooooo`05o`000?ooooooooooooooool000002Oooool4o`0000[ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`2Kooooo`Co0000:Oooool000;ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0Iooooo`05o`000?ooooooooooooooool000001oooool4
o`0000cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`2Gooooo`?o0000;Oooool0
00;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Iooooo`05o`000?oooooooooo
ooooool000001?ooool3o`0000?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo09Cooooo0ol0000`ooooo`000_ooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo01Wooooo00Co0000ooooool0003ooooo1?l00007ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2@ooooo`Co0000<oooool0
00;ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Iooooo`Co00002oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0SOooool3o`00
03Oooooo0002ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05oooool3o`000003
ooooool0003ooooo00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo08Wooooo1?l0000jooooo`0000?oooooo`000?ooool03_ooool00ol0003ooooo
ooooo`0Dooooo`?o00000oooool2o`0000gooooo00?o0000ooooooooool02oooool01Ol0003ooooo
oooooooooooo000008Sooooo0ol0000nooooo`0000?oooooo`000?ooool03_ooool00ol0003ooooo
ooooo`0Aooooo`?o00001_ooool2o`0000gooooo00?o0000ooooooooool03?ooool01?l0003ooooo
ooooool00024ooooo`Co0000@Oooool00003ooooool0003ooooo00oooooo00?o0000ooooooooool0
3?ooool4o`0000Wooooo0_l0000=ooooo`03o`000?oooooooooo00cooooo00Co0000ooooool0003o
0000POooool3o`0004Gooooo00000ooooooo0000ooooo`0?ooooo`03o`000?oooooooooo00Wooooo
0ol0000=ooooo`;o00003Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo07gooooo
1?l00018ooooo`0000?oooooo`000?ooool03oooool00ol0003oooooooooo`06ooooo`?o00004Ooo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo08[ooooo0ol0001<ooooo`0000?ooooo
o`000?ooool03oooool00ol0003oooooooooo`03ooooo`?o00005?ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo08Kooooo1?l0001?ooooo`0000?oooooo`000?ooool03oooool00ol0
003oooooooooo`03o`0001Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`23oooo
o`?o0000Doooool00003ooooool0003ooooo00oooooo0ol0000Jooooo`;o00003?ooool00ol0003o
ooooooooo`1oooooo`Co0000E_ooool00003ooooool0003ooooo00_ooooo1?l000000ooooooo0000
ooooo`0Jooooo`;o00003?ooool00ol0003oooooooooo`1looooo`?o0000F_ooool00003o`000?oo
oooooooo00Sooooo0ol00005ooooo`03o`000?oooooooooo01Wooooo0_l0000<ooooo`03o`000?oo
oooooooo07Sooooo1?l0001Mooooo`0000?o0000ooooooooool01Oooool3o`0000Sooooo00?o0000
ooooooooool06Oooool00ol0003oooooo`00000;ooooo`03o`000?oooooooooo07Gooooo0ol0001Q
ooooo`0000?o0000ooooooooool00_ooool3o`0000_ooooo00?o0000ooooooooool06Oooool01?l0
003oooooooooool0000:ooooo`03o`000?oooooooooo07;ooooo0ol0001Tooooo`0000?o0000oooo
ool000000_l0000?ooooo`03o`000?oooooooooo01Oooooo00Go0000ooooooooooooooooo`00000:
ooooo`03o`000?oooooooooo06kooooo1?l0001Wooooo`000_l0000Booooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
06_ooooo0ol0001[ooooo`000_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo06So
oooo1?l0001^ooooo`000oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`;o0000Ioooool3o`0007;ooooo
0004ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool05_ooool00ol0003ooooooooo
o`05ooooo`?o000000?oooooo`000?ooool0I?ooool4o`0007Gooooo0005ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo067ooooo0ol0001iooooo`001_ooool2o`0000kooooo00?o0000ooooooooool05Oooool00ol0
003oooooooooo`1Xooooo`Co0000O?ooool000Sooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo06Gooooo0ol00020ooooo`002Oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0HOooool4o`0008?ooooo
000:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04oooool00ol0003ooooooooo
o`1Nooooo`?o0000Qoooool000_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo05[ooooo1?l0002:ooooo`003?ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo017ooooo0_l0001Iooooo`?o0000S_ooool000gooooo0_l0000:ooooo`03
o`000?oooooooooo017ooooo0_l0001Eooooo`Co0000TOooool000oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0@ooooo`;o0000D_ooool3o`0009Gooooo000@ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool03oooool2o`0004kooooo1?l0002Hooooo`004Oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo0_l0001;ooooo`?o0000W?ooool0
01;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0=ooooo`;o0000BOooool3o`00
09oooooo000Cooooo`;o00002?ooool2o`0000gooooo0_l00015ooooo`Co0000X_ooool001Gooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`0:ooooo`;o0000@_ooool3o`000:Kooooo
000Fooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool2o`000003ooooool0
003ooooo03gooooo1?l0002Yooooo`005oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Gooooo00Go0000ooooooooooooooooo`00000kooooo`?o0000[Oooool001Sooooo00?o0000
ooooooooool01oooool4o`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0e
ooooo`Co0000/?ooool001Wooooo0_l0000;ooooo`;o00001Oooool00ol0003oooooooooo`0boooo
o`?o0000]?ooool001_ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0^ooooo`Co
0000]oooool001cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0[ooooo`?o0000
^oooool001gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Wooooo`Co0000__oo
ool001kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Tooooo`?o0000`_ooool0
01oooooo0_l0000<ooooo`03o`000?oooooooooo023ooooo1?l00035ooooo`008Oooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo01gooooo0ol00039ooooo`008_ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo01Wooooo1?l0003<ooooo`008oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo01Kooooo0ol0003@ooooo`009?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo01Cooooo0ol0003Cooooo`009Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo013ooooo1?l0003Fooooo`009_ooool2o`0000Cooooo00?o0000oooooooo
ool03Oooool3o`000=[ooooo000Xooooo`05o`000?ooooooooooooooool000002oooool4o`000=go
oooo000Yooooo`04o`000?ooooooooooo`0000Sooooo0ol0003Qooooo`00:_ooool00ol0003ooooo
o`000004ooooo`Co0000i?ooool002_ooooo0_l000001?oooooo0000o`000?l0003Xooooo`00;?oo
ool2o`000>_ooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.875}, {190.438, 0}} -> {0.0219893, 0.106871, \
0.00376814, 0.00376814}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Combination of All the Pictures"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[p1, p2, p3, p4];\)\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .67912 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0224888 1.02249 -0.150431 1.02249 [
[.02846 .27668 -2.67377 -9 ]
[.02846 .27668 3.32623 0 ]
[.18704 .22058 -2.78329 -9 ]
[.18704 .22058 3.21671 0 ]
[.35321 .1618 -2.90126 -9 ]
[.35321 .1618 3.09874 0 ]
[.52756 .10014 -3.0287 -9 ]
[.52756 .10014 2.9713 0 ]
[.71068 .0354 -3.1668 -9 ]
[.71068 .0354 2.8332 0 ]
[.86008 -0.00425 0 -6.08625 ]
[.86008 -0.00425 12 2.91375 ]
[.8924 .04484 0 -6.05064 ]
[.8924 .04484 24 2.94936 ]
[.92355 .09216 0 -6.0166 ]
[.92355 .09216 6 2.9834 ]
[.9536 .13781 0 -5.98402 ]
[.9536 .13781 18 3.01598 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 6 3.04719 ]
[.98261 .18188 0 -5.95281 ]
[.98261 .18188 12 3.04719 ]
[.9897 .2427 0 -5.91612 ]
[.9897 .2427 24 3.08388 ]
[.99701 .30533 0 -5.87841 ]
[.99701 .30533 6 3.12159 ]
[1.00453 .36986 0 -5.83963 ]
[1.00453 .36986 18 3.16037 ]
[1.01228 .43637 0 -5.79975 ]
[1.01228 .43637 6 3.20025 ]
[ 0 0 0 0 ]
[ 1 .67912 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.84803 0 m
.842 .00212 L
s
[(-1)] .86008 -0.00425 -1 .3525 Mshowa
.88031 .049 m
.87427 .05108 L
s
[(-0.5)] .8924 .04484 -1 .34459 Mshowa
.91144 .09624 m
.90538 .09828 L
s
[(0)] .92355 .09216 -1 .33702 Mshowa
.94146 .14181 m
.93539 .14381 L
s
[(0.5)] .9536 .13781 -1 .32978 Mshowa
.97045 .1858 m
.96437 .18777 L
s
[(1)] .98261 .18188 -1 .32285 Mshowa
.125 Mabswid
.85458 .00995 m
.85096 .01122 L
s
.86108 .01982 m
.85746 .02108 L
s
.86754 .02962 m
.86392 .03088 L
s
.87395 .03934 m
.87033 .0406 L
s
.88663 .05859 m
.883 .05983 L
s
.8929 .0681 m
.88927 .06934 L
s
.89912 .07755 m
.89549 .07878 L
s
.9053 .08693 m
.90167 .08816 L
s
.91753 .10548 m
.91389 .1067 L
s
.92358 .11466 m
.91994 .11588 L
s
.92958 .12378 m
.92594 .12499 L
s
.93554 .13283 m
.9319 .13403 L
s
.94734 .15073 m
.9437 .15193 L
s
.95318 .15959 m
.94953 .16078 L
s
.95898 .16839 m
.95533 .16958 L
s
.96473 .17713 m
.96108 .17831 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
.25 Mabswid
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
.18827 .43833 m
.02708 .28938 L
s
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.18827 .43833 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.17181 .67912 L
s
.17181 .67912 m
.18827 .43833 L
s
0 0 m
1 0 L
1 .67912 L
0 .67912 L
closepath
clip
newpath
.5 Mabswid
.18827 .43833 m
.18742 .43287 L
s
.18742 .43287 m
.18038 .42164 L
s
.18038 .42164 m
.16817 .40556 L
s
.24329 .44744 m
.24711 .44635 L
s
.23902 .45664 m
.24329 .44744 L
s
.16817 .40556 m
.15224 .38595 L
s
.24711 .44635 m
.25051 .4531 L
s
.23429 .47357 m
.23902 .45664 L
s
.25051 .4531 m
.25355 .46682 L
s
.22915 .4972 m
.23429 .47357 L
s
.24073 .39161 m
.24557 .39132 L
s
.23107 .38727 m
.24073 .39161 L
s
.24557 .39132 m
.24569 .38644 L
s
.25355 .46682 m
.25634 .48607 L
s
.21686 .37859 m
.23107 .38727 L
s
.24569 .38644 m
.24154 .3774 L
s
.15224 .38595 m
.13431 .36439 L
s
.22368 .52587 m
.22915 .4972 L
s
.1988 .36625 m
.21686 .37859 L
s
.18026 .55551 m
.17694 .58558 L
s
.18026 .55551 m
.18171 .58968 L
s
.18026 .55551 m
.17307 .58675 L
s
.25634 .48607 m
.25898 .50899 L
s
.24154 .3774 m
.2339 .36493 L
s
.14421 .45186 m
.15335 .48199 L
s
.13079 .42362 m
.14421 .45186 L
s
.15335 .48199 m
.15761 .51151 L
s
.218 .55735 m
.22368 .52587 L
s
.11403 .39971 m
.13079 .42362 L
s
.15761 .51151 m
.15676 .53803 L
s
.17793 .35128 m
.1988 .36625 L
s
.32353 .44763 m
.32744 .44713 L
s
.3194 .45396 m
.32353 .44763 L
s
.2339 .36493 m
.22385 .35006 L
s
.25898 .50899 m
.26158 .53341 L
s
.31505 .46587 m
.3194 .45396 L
s
.13431 .36439 m
.11634 .3427 L
s
.32744 .44713 m
.33116 .4522 L
s
.31049 .48265 m
.31505 .46587 L
s
.33116 .4522 m
.33472 .46215 L
s
.18171 .58968 m
.18348 .62003 L
s
.21226 .589 m
.218 .55735 L
s
.09521 .3824 m
.11403 .39971 L
s
.17307 .58675 m
.15955 .60872 L
s
.15676 .53803 m
.15096 .5594 L
s
.17694 .58558 m
.16736 .60638 L
s
.1323 .46386 m
.13843 .48534 L
s
.12305 .44355 m
.1323 .46386 L
s
.30575 .50313 m
.31049 .48265 L
s
.13843 .48534 m
.14103 .50617 L
s
.33472 .46215 m
.33818 .4759 L
s
.21367 .42943 m
.22683 .45861 L
s
.19639 .40212 m
.21367 .42943 L
s
.15563 .33501 m
.17793 .35128 L
s
.11133 .4262 m
.12305 .44355 L
s
.26158 .53341 m
.26428 .55703 L
s
.22385 .35006 m
.21263 .33398 L
s
.30759 .34988 m
.31186 .3489 L
s
.29994 .34746 m
.30759 .34988 L
s
.22683 .45861 m
.23528 .48715 L
s
.31186 .3489 m
.31286 .34459 L
s
.14103 .50617 m
.13996 .52463 L
s
.28911 .34185 m
.29994 .34746 L
s
.17591 .37917 m
.19639 .40212 L
s
.31286 .34459 m
.31094 .33729 L
s
.30089 .52572 m
.30575 .50313 L
s
.20664 .61798 m
.21226 .589 L
s
.33818 .4759 m
.34159 .49206 L
s
.11634 .3427 m
.10029 .32272 L
s
.09808 .41346 m
.11133 .4262 L
s
.18348 .62003 m
.18574 .64369 L
s
.27554 .33352 m
.28911 .34185 L
s
.23528 .48715 m
.23879 .51261 L
s
.07584 .37356 m
.09521 .3824 L
s
.12349 .47176 m
.12757 .48703 L
s
.11713 .4572 m
.12349 .47176 L
s
.13996 .52463 m
.13539 .53919 L
s
.15096 .5594 m
.14077 .57387 L
s
.12757 .48703 m
.1291 .50167 L
s
.31094 .33729 m
.3067 .32759 L
s
.10898 .44463 m
.11713 .4572 L
s
.15347 .36286 m
.17591 .37917 L
s
.26428 .55703 m
.26717 .57761 L
s
.13354 .31901 m
.15563 .33501 L
s
.296 .54857 m
.30089 .52572 L
s
.1291 .50167 m
.12802 .51447 L
s
.21263 .33398 m
.20162 .31802 L
s
.25998 .32322 m
.27554 .33352 L
s
.34159 .49206 m
.345 .50905 L
s
.09967 .43526 m
.10898 .44463 L
s
.20132 .64147 m
.20664 .61798 L
s
.08438 .40668 m
.09808 .41346 L
s
.15955 .60872 m
.14086 .61954 L
s
.117 .47691 m
.11969 .48772 L
s
.11266 .46649 m
.117 .47691 L
s
.4068 .4401 m
.41083 .43983 L
s
.40269 .44455 m
.4068 .4401 L
s
.3985 .45301 m
.40269 .44455 L
s
.18574 .64369 m
.18863 .65845 L
s
.3067 .32759 m
.3009 .31625 L
s
.11969 .48772 m
.12056 .49799 L
s
.23879 .51261 m
.23749 .53283 L
s
.107 .45741 m
.11266 .46649 L
s
.12802 .51447 m
.12449 .52436 L
s
.41083 .43983 m
.4148 .44349 L
s
.13539 .53919 m
.1278 .54869 L
s
.16736 .60638 m
.15271 .616 L
s
.39423 .46502 m
.3985 .45301 L
s
.29114 .56967 m
.296 .54857 L
s
.12056 .49799 m
.11958 .50683 L
s
.10047 .45052 m
.107 .45741 L
s
.08998 .43006 m
.09967 .43526 L
s
.26717 .57761 m
.27034 .59323 L
s
.24336 .31193 m
.25998 .32322 L
s
.10029 .32272 m
.08799 .30617 L
s
.4148 .44349 m
.41873 .45057 L
s
.345 .50905 m
.34848 .52522 L
s
.19646 .65705 m
.20132 .64147 L
s
.38988 .47973 m
.39423 .46502 L
s
.11226 .48022 m
.11402 .48786 L
s
.10931 .47278 m
.11226 .48022 L
s
.10539 .46623 m
.10931 .47278 L
s
.11402 .48786 m
.11448 .49503 L
s
.13054 .35509 m
.15347 .36286 L
s
.11958 .50683 m
.11688 .51354 L
s
.14077 .57387 m
.12711 .58025 L
s
.11338 .30491 m
.13354 .31901 L
s
.12449 .52436 m
.11887 .53056 L
s
.18863 .65845 m
.19221 .66299 L
s
.20162 .31802 m
.19214 .30351 L
s
.05762 .37452 m
.07584 .37356 L
s
.09363 .44653 m
.10047 .45052 L
s
.10082 .46117 m
.10539 .46623 L
s
.11448 .49503 m
.11364 .50114 L
s
.41873 .45057 m
.42264 .46023 L
s
.3009 .31625 m
.29443 .30418 L
s
.28642 .58707 m
.29114 .56967 L
s
.1088 .48232 m
.10995 .4877 L
s
.1068 .47702 m
.1088 .48232 L
s
.38547 .49605 m
.38988 .47973 L
s
.07143 .4068 m
.08438 .40668 L
s
.19221 .66299 m
.19646 .65705 L
s
.1041 .4723 m
.1068 .47702 L
s
.10995 .4877 m
.11017 .49271 L
s
.11364 .50114 m
.1116 .50566 L
s
.09599 .45813 m
.10082 .46117 L
s
.10091 .4686 m
.1041 .4723 L
s
.27034 .59323 m
.27385 .60242 L
s
.11688 .51354 m
.11276 .51756 L
s
.11017 .49271 m
.10947 .49691 L
s
.08077 .42969 m
.08998 .43006 L
s
.1278 .54869 m
.11788 .55235 L
s
.22681 .30074 m
.24336 .31193 L
s
.10629 .48363 m
.10703 .48742 L
s
.10494 .47986 m
.10629 .48363 L
s
.10308 .47647 m
.10494 .47986 L
s
.34848 .52522 m
.35207 .53905 L
s
.10703 .48742 m
.10711 .4909 L
s
.38117 .3111 m
.38519 .30971 L
s
.3748 .31001 m
.38117 .3111 L
s
.0975 .46629 m
.10091 .4686 L
s
.08708 .44594 m
.09363 .44653 L
s
.10085 .47376 m
.10308 .47647 L
s
.10947 .49691 m
.10794 .49996 L
s
.3662 .30656 m
.3748 .31001 L
s
.10711 .4909 m
.10654 .49379 L
s
.38519 .30971 m
.38697 .30591 L
s
.42264 .46023 m
.42655 .47147 L
s
.1116 .50566 m
.10858 .50826 L
s
.23749 .53283 m
.23192 .54603 L
s
.10448 .48443 m
.10495 .48709 L
s
.10357 .48175 m
.10448 .48443 L
s
.10229 .47932 m
.10357 .48175 L
s
.09133 .45746 m
.09599 .45813 L
s
.09846 .47201 m
.10085 .47376 L
s
.38104 .51267 m
.38547 .49605 L
s
.11887 .53056 m
.1117 .53259 L
s
.28192 .59907 m
.28642 .58707 L
s
.10495 .48709 m
.10495 .48951 L
s
.10074 .47734 m
.10229 .47932 L
s
.10654 .49379 m
.1054 .49583 L
s
.10495 .48951 m
.1045 .49149 L
s
.09419 .46563 m
.0975 .46629 L
s
.10317 .4849 m
.10346 .48677 L
s
.10256 .48301 m
.10317 .4849 L
s
.10168 .48126 m
.10256 .48301 L
s
.09905 .47603 m
.10074 .47734 L
s
.10794 .49996 m
.10574 .50162 L
s
.10346 .48677 m
.10343 .48845 L
s
.1006 .47983 m
.10168 .48126 L
s
.35568 .30111 m
.3662 .30656 L
s
.27385 .60242 m
.27771 .60439 L
s
.0961 .47142 m
.09846 .47201 L
s
.08799 .30617 m
.08089 .29446 L
s
.1045 .49149 m
.10365 .49286 L
s
.11276 .51756 m
.10759 .51861 L
s
.38697 .30591 m
.38676 .29998 L
s
.09942 .47884 m
.1006 .47983 L
s
.1054 .49583 m
.1038 .49688 L
s
.09738 .47552 m
.09905 .47603 L
s
.09685 .29431 m
.11338 .30491 L
s
.09823 .47842 m
.09942 .47884 L
s
.10365 .49286 m
.1025 .49351 L
s
.10858 .50826 m
.10487 .50874 L
s
.27771 .60439 m
.28192 .59907 L
s
.29443 .30418 m
.28825 .29235 L
s
.19214 .30351 m
.18541 .29163 L
s
.094 .47209 m
.0961 .47142 L
s
.09587 .47589 m
.09738 .47552 L
s
.10574 .50162 m
.10308 .50178 L
s
.09126 .46676 m
.09419 .46563 L
s
.09715 .47861 m
.09823 .47842 L
s
.08726 .45933 m
.09133 .45746 L
s
.1038 .49688 m
.1019 .49688 L
s
.1025 .49351 m
.10114 .49342 L
s
.28573 .41449 m
.29609 .43515 L
s
.27249 .39495 m
.28573 .41449 L
s
.08142 .44894 m
.08708 .44594 L
s
.35207 .53905 m
.3558 .5492 L
s
.09628 .47943 m
.09715 .47861 L
s
.3766 .52817 m
.38104 .51267 L
s
.42655 .47147 m
.43049 .48313 L
s
.09468 .47714 m
.09587 .47589 L
s
.34373 .29418 m
.35568 .30111 L
s
.07291 .43443 m
.08077 .42969 L
s
.10114 .49342 m
.09971 .49262 L
s
.2115 .29084 m
.22681 .30074 L
s
.09236 .47399 m
.094 .47209 L
s
.1019 .49688 m
.09988 .49585 L
s
.0957 .48082 m
.09628 .47943 L
s
.14086 .61954 m
.11866 .61822 L
s
.38676 .29998 m
.38501 .29237 L
s
.29609 .43515 m
.30316 .45507 L
s
.25703 .37838 m
.27249 .39495 L
s
.10308 .50178 m
.10021 .50048 L
s
.09971 .49262 m
.09834 .49119 L
s
.10487 .50874 m
.10082 .50713 L
s
.09391 .47919 m
.09468 .47714 L
s
.08902 .46964 m
.09126 .46676 L
s
.10877 .35721 m
.13054 .35509 L
s
.09549 .48266 m
.0957 .48082 L
s
.10759 .51861 m
.10188 .51668 L
s
.12711 .58025 m
.11124 .57803 L
s
.06048 .41417 m
.07143 .4068 L
s
.1117 .53259 m
.10366 .53036 L
s
.09988 .49585 m
.09791 .49391 L
s
.09834 .49119 m
.09714 .48929 L
s
.11788 .55235 m
.10656 .54996 L
s
.09566 .48482 m
.09549 .48266 L
s
.09135 .477 m
.09236 .47399 L
s
.09366 .48187 m
.09391 .47919 L
s
.09714 .48929 m
.09623 .4871 L
s
.09623 .4871 m
.09566 .48482 L
s
.08419 .46365 m
.08726 .45933 L
s
.10021 .50048 m
.0974 .49787 L
s
.09791 .49391 m
.09618 .49128 L
s
.15271 .616 m
.13461 .61343 L
s
.09397 .48497 m
.09366 .48187 L
s
.37222 .54117 m
.3766 .52817 L
s
.09618 .49128 m
.09483 .4882 L
s
.09483 .4882 m
.09397 .48497 L
s
.08769 .47407 m
.08902 .46964 L
s
.09108 .48089 m
.09135 .477 L
s
.10082 .50713 m
.09681 .50363 L
s
.3558 .5492 m
.35968 .55473 L
s
.08089 .29446 m
.07992 .28848 L
s
.08537 .28854 m
.09685 .29431 L
s
.331 .28646 m
.34373 .29418 L
s
.0974 .49787 m
.0949 .49423 L
s
.04232 .38582 m
.05762 .37452 L
s
.07724 .45542 m
.08142 .44894 L
s
.43049 .48313 m
.43446 .49407 L
s
.48864 .42999 m
.49279 .42676 L
s
.48448 .43611 m
.48864 .42999 L
s
.30316 .45507 m
.30678 .47248 L
s
.09161 .48532 m
.09108 .48089 L
s
.24023 .36645 m
.25703 .37838 L
s
.49279 .42676 m
.49696 .4265 L
s
.38501 .29237 m
.38226 .28365 L
s
.28825 .29235 m
.28326 .28168 L
s
.0949 .49423 m
.09291 .48991 L
s
.10188 .51668 m
.09615 .512 L
s
.48032 .4448 m
.48448 .43611 L
s
.09291 .48991 m
.09161 .48532 L
s
.18541 .29163 m
.18234 .28331 L
s
.08742 .4797 m
.08769 .47407 L
s
.08245 .47015 m
.08419 .46365 L
s
.49696 .4265 m
.50113 .42902 L
s
.09681 .50363 m
.09318 .4986 L
s
.19857 .28336 m
.2115 .29084 L
s
.36791 .55047 m
.37222 .54117 L
s
.35968 .55473 m
.36372 .55515 L
s
.47614 .45548 m
.48032 .4448 L
s
.10366 .53036 m
.09547 .52416 L
s
.0883 .48605 m
.08742 .4797 L
s
.06719 .4441 m
.07291 .43443 L
s
.07992 .28848 m
.08537 .28854 L
s
.09318 .4986 m
.09027 .49255 L
s
.23192 .54603 m
.22293 .55102 L
s
.36372 .55515 m
.36791 .55047 L
s
.50113 .42902 m
.50533 .43391 L
s
.09027 .49255 m
.0883 .48605 L
s
.09615 .512 m
.09091 .50508 L
s
.31825 .27876 m
.331 .28646 L
s
.08225 .47829 m
.08245 .47015 L
s
.47194 .46738 m
.47614 .45548 L
s
.07497 .46493 m
.07724 .45542 L
s
.43446 .49407 m
.43848 .5032 L
s
.10656 .54996 m
.0949 .54182 L
s
.38226 .28365 m
.37915 .2745 L
s
.18901 .27923 m
.19857 .28336 L
s
.18234 .28331 m
.1835 .27913 L
s
.50533 .43391 m
.50955 .44056 L
s
.09091 .50508 m
.08663 .4966 L
s
.08367 .48738 m
.08225 .47829 L
s
.30678 .47248 m
.30708 .48585 L
s
.22312 .36057 m
.24023 .36645 L
s
.28326 .28168 m
.28025 .27302 L
s
.46773 .47957 m
.47194 .46738 L
s
.05266 .42853 m
.06048 .41417 L
s
.09547 .52416 m
.08791 .51465 L
s
.08663 .4966 m
.08367 .48738 L
s
.1835 .27913 m
.18901 .27923 L
s
.30629 .27191 m
.31825 .27876 L
s
.11124 .57803 m
.09462 .56749 L
s
.07492 .47671 m
.07497 .46493 L
s
.43848 .5032 m
.44256 .50964 L
s
.06426 .45801 m
.06719 .4441 L
s
.50955 .44056 m
.5138 .44822 L
s
.4635 .49107 m
.46773 .47957 L
s
.0899 .36977 m
.10877 .35721 L
s
.08791 .51465 m
.08163 .50278 L
s
.37915 .2745 m
.37633 .26561 L
s
.46021 .27432 m
.46418 .2727 L
s
.45463 .27413 m
.46021 .27432 L
s
.44749 .27222 m
.45463 .27413 L
s
.07719 .48972 m
.07492 .47671 L
s
.28025 .27302 m
.27982 .26697 L
s
.44256 .50964 m
.44668 .51275 L
s
.46418 .2727 m
.4666 .26934 L
s
.45927 .50089 m
.4635 .49107 L
s
.0949 .54182 m
.08396 .5288 L
s
.439 .26882 m
.44749 .27222 L
s
.29589 .26674 m
.30629 .27191 L
s
.11866 .61822 m
.095 .60486 L
s
.08163 .50278 m
.07719 .48972 L
s
.5138 .44822 m
.51807 .45609 L
s
.4666 .26934 m
.4677 .26447 L
s
.45505 .50817 m
.45927 .50089 L
s
.44668 .51275 m
.45085 .51225 L
s
.03157 .40708 m
.04232 .38582 L
s
.42949 .26431 m
.439 .26882 L
s
.30708 .48585 m
.30445 .49398 L
s
.45085 .51225 m
.45505 .50817 L
s
.06452 .47505 m
.06426 .45801 L
s
.20687 .36169 m
.22312 .36057 L
s
.27982 .26697 m
.2823 .26391 L
s
.28773 .2639 m
.29589 .26674 L
s
.13461 .61343 m
.11509 .59877 L
s
.37633 .26561 m
.37441 .25766 L
s
.22293 .55102 m
.21172 .54727 L
s
.04888 .44887 m
.05266 .42853 L
s
.4677 .26447 m
.46777 .25842 L
s
.41941 .25918 m
.42949 .26431 L
s
.51807 .45609 m
.52236 .46333 L
s
.2823 .26391 m
.28773 .2639 L
s
.08396 .5288 m
.07476 .5122 L
s
.09462 .56749 m
.07881 .54973 L
s
.0681 .49369 m
.06452 .47505 L
s
.40926 .25401 m
.41941 .25918 L
s
.57711 .41147 m
.58135 .409 L
s
.57291 .41601 m
.57711 .41147 L
s
.56874 .42241 m
.57291 .41601 L
s
.46777 .25842 m
.46722 .25163 L
s
.58135 .409 m
.58565 .40865 L
s
.07476 .5122 m
.0681 .49369 L
s
.52236 .46333 m
.52665 .46921 L
s
.37441 .25766 m
.37391 .2512 L
s
.36367 .39466 m
.37215 .4091 L
s
.35319 .38085 m
.36367 .39466 L
s
.5646 .43027 m
.56874 .42241 L
s
.34118 .36902 m
.35319 .38085 L
s
.58565 .40865 m
.58999 .41024 L
s
.56046 .43905 m
.5646 .43027 L
s
.37215 .4091 m
.37835 .4228 L
s
.3996 .2494 m
.40926 .25401 L
s
.58999 .41024 m
.59439 .41348 L
s
.52665 .46921 m
.53095 .47311 L
s
.55631 .44811 m
.56046 .43905 L
s
.32825 .36041 m
.34118 .36902 L
s
.07551 .39236 m
.0899 .36977 L
s
.30445 .49398 m
.29954 .49612 L
s
.46722 .25163 m
.46648 .24459 L
s
.37391 .2512 m
.37521 .24667 L
s
.19263 .37024 m
.20687 .36169 L
s
.04973 .47353 m
.04888 .44887 L
s
.55215 .45675 m
.55631 .44811 L
s
.59439 .41348 m
.59882 .41792 L
s
.39097 .24594 m
.3996 .2494 L
s
.37835 .4228 m
.38216 .43451 L
s
.53095 .47311 m
.53524 .47463 L
s
.07881 .54973 m
.0653 .52654 L
s
.54797 .46426 m
.55215 .45675 L
s
.37521 .24667 m
.37851 .24431 L
s
.095 .60486 m
.07213 .58076 L
s
.38382 .24412 m
.39097 .24594 L
s
.02671 .43683 m
.03157 .40708 L
s
.53524 .47463 m
.53951 .47358 L
s
.54375 .47003 m
.54797 .46426 L
s
.59882 .41792 m
.6033 .423 L
s
.31514 .35605 m
.32825 .36041 L
s
.46648 .24459 m
.46599 .2378 L
s
.37851 .24431 m
.38382 .24412 L
s
.53951 .47358 m
.54375 .47003 L
s
.21172 .54727 m
.19969 .53509 L
s
.05533 .50027 m
.04973 .47353 L
s
.38216 .43451 m
.38369 .44315 L
s
.0653 .52654 m
.05533 .50027 L
s
.6033 .423 m
.60779 .42816 L
s
.53868 .23924 m
.54381 .23881 L
s
.53248 .23841 m
.53868 .23924 L
s
.11509 .59877 m
.09636 .57331 L
s
.54381 .23881 m
.54783 .23707 L
s
.52532 .23647 m
.53248 .23841 L
s
.46599 .2378 m
.46618 .23175 L
s
.54783 .23707 m
.5508 .23408 L
s
.51745 .2337 m
.52532 .23647 L
s
.29954 .49612 m
.29317 .49203 L
s
.30263 .35666 m
.31514 .35605 L
s
.60779 .42816 m
.61229 .4328 L
s
.18146 .38593 m
.19263 .37024 L
s
.5508 .23408 m
.55289 .23001 L
s
.50915 .23045 m
.51745 .2337 L
s
.46618 .23175 m
.46738 .22682 L
s
.50077 .22712 m
.50915 .23045 L
s
.06692 .42353 m
.07551 .39236 L
s
.55289 .23001 m
.5543 .22512 L
s
.61229 .4328 m
.61677 .43641 L
s
.38369 .44315 m
.38322 .4479 L
s
.49269 .22416 m
.50077 .22712 L
s
.02858 .4726 m
.02671 .43683 L
s
.46738 .22682 m
.46983 .22331 L
s
.07213 .58076 m
.05226 .54838 L
s
.66375 .39334 m
.66804 .38985 L
s
.65951 .39816 m
.66375 .39334 L
s
.61677 .43641 m
.62122 .43859 L
s
.66804 .38985 m
.67239 .38786 L
s
.65532 .40406 m
.65951 .39816 L
s
.5543 .22512 m
.55532 .21974 L
s
.67239 .38786 m
.67681 .38735 L
s
.65114 .41066 m
.65532 .40406 L
s
.48528 .22199 m
.49269 .22416 L
s
.19969 .53509 m
.18835 .51559 L
s
.29152 .36254 m
.30263 .35666 L
s
.46983 .22331 m
.47366 .22135 L
s
.64697 .4175 m
.65114 .41066 L
s
.67681 .38735 m
.6813 .38822 L
s
.62122 .43859 m
.62564 .43905 L
s
.47885 .22096 m
.48528 .22199 L
s
.47366 .22135 m
.47885 .22096 L
s
.64279 .42409 m
.64697 .4175 L
s
.62564 .43905 m
.63 .4377 L
s
.6813 .38822 m
.68585 .39022 L
s
.55532 .21974 m
.55625 .21422 L
s
.63857 .42993 m
.64279 .42409 L
s
.29317 .49203 m
.28632 .48207 L
s
.17423 .40777 m
.18146 .38593 L
s
.63 .4377 m
.63431 .43458 L
s
.63431 .43458 m
.63857 .42993 L
s
.09636 .57331 m
.08061 .5395 L
s
.38322 .4479 m
.3812 .44832 L
s
.68585 .39022 m
.69045 .39303 L
s
.43791 .36167 m
.44652 .37127 L
s
.42824 .35336 m
.43791 .36167 L
s
.44652 .37127 m
.45376 .38119 L
s
.0373 .51105 m
.02858 .4726 L
s
.55625 .21422 m
.5574 .20893 L
s
.05226 .54838 m
.0373 .51105 L
s
.41796 .34727 m
.42824 .35336 L
s
.45376 .38119 m
.45942 .39045 L
s
.69045 .39303 m
.69508 .39625 L
s
.06493 .46077 m
.06692 .42353 L
s
.28251 .37353 m
.29152 .36254 L
s
.5574 .20893 m
.55905 .20421 L
s
.18835 .51559 m
.17912 .49061 L
s
.40756 .34416 m
.41796 .34727 L
s
.69508 .39625 m
.69973 .39947 L
s
.45942 .39045 m
.46345 .39814 L
s
.17145 .43406 m
.17423 .40777 L
s
.28632 .48207 m
.28 .46713 L
s
.62645 .20488 m
.63134 .20402 L
s
.62082 .2048 m
.62645 .20488 L
s
.61453 .20391 m
.62082 .2048 L
s
.3812 .44832 m
.37823 .44431 L
s
.69973 .39947 m
.70437 .40227 L
s
.55905 .20421 m
.56141 .20033 L
s
.63134 .20402 m
.63548 .20222 L
s
.60773 .2024 m
.61453 .20391 L
s
.08061 .5395 m
.0697 .50071 L
s
.60062 .2005 m
.60773 .2024 L
s
.63548 .20222 m
.6389 .19952 L
s
.39758 .34455 m
.40756 .34416 L
s
.46345 .39814 m
.4659 .40351 L
s
.27618 .38896 m
.28251 .37353 L
s
.0697 .50071 m
.06493 .46077 L
s
.70437 .40227 m
.70899 .40431 L
s
.59343 .19853 m
.60062 .2005 L
s
.56141 .20033 m
.56464 .19748 L
s
.6389 .19952 m
.64174 .19606 L
s
.17912 .49061 m
.1732 .46255 L
s
.58642 .19678 m
.59343 .19853 L
s
.1732 .46255 m
.17145 .43406 L
s
.56464 .19748 m
.56881 .19577 L
s
.70899 .40431 m
.71357 .40531 L
s
.57984 .19557 m
.58642 .19678 L
s
.64174 .19606 m
.64414 .19203 L
s
.56881 .19577 m
.57391 .19517 L
s
.57391 .19517 m
.57984 .19557 L
s
.71357 .40531 m
.71809 .40507 L
s
.38858 .3487 m
.39758 .34455 L
s
.28 .46713 m
.27517 .44859 L
s
.75266 .37232 m
.757 .36856 L
s
.74837 .37686 m
.75266 .37232 L
s
.37823 .44431 m
.37496 .43621 L
s
.4659 .40351 m
.46699 .40603 L
s
.757 .36856 m
.7614 .36578 L
s
.7441 .38192 m
.74837 .37686 L
s
.27286 .40769 m
.27618 .38896 L
s
.71809 .40507 m
.72255 .40355 L
s
.7614 .36578 m
.76588 .36405 L
s
.64414 .19203 m
.6463 .18767 L
s
.73985 .3872 m
.7441 .38192 L
s
.73558 .39233 m
.73985 .3872 L
s
.72255 .40355 m
.72695 .40079 L
s
.76588 .36405 m
.77043 .36339 L
s
.73129 .39697 m
.73558 .39233 L
s
.72695 .40079 m
.73129 .39697 L
s
.77043 .36339 m
.77504 .36368 L
s
.6463 .18767 m
.64842 .18324 L
s
.27517 .44859 m
.2726 .42816 L
s
.2726 .42816 m
.27286 .40769 L
s
.77504 .36368 m
.77972 .36475 L
s
.38102 .35651 m
.38858 .3487 L
s
.77972 .36475 m
.78445 .36636 L
s
.46699 .40603 m
.46704 .40541 L
s
.64842 .18324 m
.65072 .17902 L
s
.37496 .43621 m
.37209 .42472 L
s
.78445 .36636 m
.78921 .36824 L
s
.65072 .17902 m
.65338 .17522 L
s
.37528 .36754 m
.38102 .35651 L
s
.78921 .36824 m
.79398 .37007 L
s
.52622 .33873 m
.53359 .34526 L
s
.51813 .33304 m
.52622 .33873 L
s
.53359 .34526 m
.54002 .35191 L
s
.50963 .32887 m
.51813 .33304 L
s
.65338 .17522 m
.65655 .17205 L
s
.37209 .42472 m
.37025 .41087 L
s
.46704 .40541 m
.46645 .40166 L
s
.54002 .35191 m
.54537 .35799 L
s
.79398 .37007 m
.79873 .37159 L
s
.50105 .32677 m
.50963 .32887 L
s
.37158 .38101 m
.37528 .36754 L
s
.65655 .17205 m
.66032 .16964 L
s
.71231 .17114 m
.7176 .17067 L
s
.70656 .171 m
.71231 .17114 L
s
.70044 .17039 m
.70656 .171 L
s
.7176 .17067 m
.72239 .16953 L
s
.6941 .16949 m
.70044 .17039 L
s
.79873 .37159 m
.80346 .37253 L
s
.66032 .16964 m
.66473 .16805 L
s
.37025 .41087 m
.36996 .39587 L
s
.72239 .16953 m
.72667 .1677 L
s
.54537 .35799 m
.5496 .36285 L
s
.68769 .1685 m
.6941 .16949 L
s
.36996 .39587 m
.37158 .38101 L
s
.49279 .32714 m
.50105 .32677 L
s
.68139 .16765 m
.68769 .1685 L
s
.66473 .16805 m
.66977 .16726 L
s
.72667 .1677 m
.73047 .16523 L
s
.67537 .16718 m
.68139 .16765 L
s
.80346 .37253 m
.80814 .37271 L
s
.66977 .16726 m
.67537 .16718 L
s
.73047 .16523 m
.73389 .16222 L
s
.46645 .40166 m
.46568 .39507 L
s
.80814 .37271 m
.81276 .37201 L
s
.5496 .36285 m
.55276 .36597 L
s
.48519 .33018 m
.49279 .32714 L
s
.81276 .37201 m
.81733 .37039 L
s
.73389 .16222 m
.73702 .15882 L
s
.81733 .37039 m
.82183 .36792 L
s
.82183 .36792 m
.82628 .3647 L
s
.82628 .3647 m
.83068 .36093 L
s
.83943 .35266 m
.84382 .34866 L
s
.83506 .35683 m
.83943 .35266 L
s
.84382 .34866 m
.84824 .34506 L
s
.83068 .36093 m
.83506 .35683 L
s
.84824 .34506 m
.85271 .34203 L
s
.85271 .34203 m
.85724 .3397 L
s
.73702 .15882 m
.74001 .1552 L
s
.85724 .3397 m
.86184 .33812 L
s
.47858 .33585 m
.48519 .33018 L
s
.46568 .39507 m
.46519 .38617 L
s
.55276 .36597 m
.55498 .36701 L
s
.86184 .33812 m
.86651 .33729 L
s
.86651 .33729 m
.87125 .33713 L
s
.74001 .1552 m
.74299 .15155 L
s
.47322 .34386 m
.47858 .33585 L
s
.87125 .33713 m
.87604 .33751 L
s
.74299 .15155 m
.74612 .14807 L
s
.46519 .38617 m
.4654 .37572 L
s
.87604 .33751 m
.88088 .33825 L
s
.55498 .36701 m
.5565 .3658 L
s
.46924 .35368 m
.47322 .34386 L
s
.74612 .14807 m
.7495 .14492 L
s
.4654 .37572 m
.46667 .36458 L
s
.88088 .33825 m
.88575 .33915 L
s
.46667 .36458 m
.46924 .35368 L
s
.7495 .14492 m
.75323 .14223 L
s
.88575 .33915 m
.89062 .33999 L
s
.5565 .3658 m
.55759 .36237 L
s
.75323 .14223 m
.75739 .1401 L
s
.89062 .33999 m
.89547 .34059 L
s
.75739 .1401 m
.76198 .13856 L
s
.61783 .31296 m
.62439 .31724 L
s
.61079 .30922 m
.61783 .31296 L
s
.89547 .34059 m
.9003 .34076 L
s
.60347 .3065 m
.61079 .30922 L
s
.76198 .13856 m
.767 .13759 L
s
.62439 .31724 m
.63031 .32153 L
s
.79566 .13766 m
.80135 .13761 L
s
.78981 .13748 m
.79566 .13766 L
s
.80135 .13761 m
.80679 .13721 L
s
.767 .13759 m
.77238 .13712 L
s
.7839 .13722 m
.78981 .13748 L
s
.59611 .30521 m
.60347 .3065 L
s
.77805 .13705 m
.7839 .13722 L
s
.80679 .13721 m
.81191 .13636 L
s
.77238 .13712 m
.77805 .13705 L
s
.9003 .34076 m
.90508 .34038 L
s
.81191 .13636 m
.81669 .13502 L
s
.55759 .36237 m
.55856 .35697 L
s
.63031 .32153 m
.6355 .32534 L
s
.81669 .13502 m
.82112 .13318 L
s
.58898 .30567 m
.59611 .30521 L
s
.90508 .34038 m
.90981 .33937 L
s
.82112 .13318 m
.82524 .13089 L
s
.90981 .33937 m
.91448 .33771 L
s
.6355 .32534 m
.63992 .32821 L
s
.5823 .30802 m
.58898 .30567 L
s
.91448 .33771 m
.9191 .33545 L
s
.82524 .13089 m
.82911 .12821 L
s
.9191 .33545 m
.92367 .33267 L
s
.55856 .35697 m
.55973 .35 L
s
.92367 .33267 m
.9282 .32952 L
s
.9282 .32952 m
.93272 .32615 L
s
.57631 .31227 m
.5823 .30802 L
s
.93272 .32615 m
.93723 .32275 L
s
.82911 .12821 m
.8328 .12526 L
s
.93723 .32275 m
.94175 .31949 L
s
.94175 .31949 m
.94631 .31653 L
s
.63992 .32821 m
.64361 .3298 L
s
.94631 .31653 m
.95092 .31398 L
s
.95092 .31398 m
.95559 .31194 L
s
.55973 .35 m
.56137 .34201 L
s
.8328 .12526 m
.8364 .12216 L
s
.57117 .31821 m
.57631 .31227 L
s
.95559 .31194 m
.96032 .31043 L
s
.96032 .31043 m
.96512 .30945 L
s
.56698 .32549 m
.57117 .31821 L
s
.56137 .34201 m
.56374 .33363 L
s
.8364 .12216 m
.84001 .11907 L
s
.64361 .3298 m
.64667 .32987 L
s
.96512 .30945 m
.96997 .30894 L
s
.56374 .33363 m
.56698 .32549 L
s
.84001 .11907 m
.84373 .11611 L
s
.96997 .30894 m
.97488 .30879 L
s
.97488 .30879 m
.97982 .30889 L
s
.84373 .11611 m
.84764 .11339 L
s
.64667 .32987 m
.64924 .32832 L
s
.97982 .30889 m
.98478 .30908 L
s
.84764 .11339 m
.85179 .11103 L
s
.85179 .11103 m
.85623 .10907 L
s
.64924 .32832 m
.65153 .3252 L
s
.85623 .10907 m
.86097 .10753 L
s
.86097 .10753 m
.866 .10641 L
s
.866 .10641 m
.87127 .10564 L
s
.87127 .10564 m
.87673 .10514 L
s
.87673 .10514 m
.8823 .10481 L
s
.65153 .3252 m
.65373 .32072 L
s
.8823 .10481 m
.88791 .10452 L
s
.88791 .10452 m
.89347 .10417 L
s
.89347 .10417 m
.89892 .10364 L
s
.89892 .10364 m
.90419 .10285 L
s
.90419 .10285 m
.90925 .10173 L
s
.7062 .28268 m
.71257 .28499 L
s
.69966 .28107 m
.7062 .28268 L
s
.71257 .28499 m
.71862 .28762 L
s
.90925 .10173 m
.91407 .10024 L
s
.69309 .28044 m
.69966 .28107 L
s
.68669 .28104 m
.69309 .28044 L
s
.71862 .28762 m
.72423 .29021 L
s
.65373 .32072 m
.65606 .31517 L
s
.68061 .28299 m
.68669 .28104 L
s
.72423 .29021 m
.72935 .29241 L
s
.65606 .31517 m
.65871 .30896 L
s
.675 .28629 m
.68061 .28299 L
s
.72935 .29241 m
.73395 .29389 L
s
.66997 .29082 m
.675 .28629 L
s
.65871 .30896 m
.66185 .30254 L
s
.66559 .29635 m
.66997 .29082 L
s
.66185 .30254 m
.66559 .29635 L
s
.73395 .29389 m
.73805 .29442 L
s
.73805 .29442 m
.74172 .29384 L
s
.74172 .29384 m
.74506 .29211 L
s
.74506 .29211 m
.7482 .28928 L
s
.7482 .28928 m
.75128 .28549 L
s
.75128 .28549 m
.75445 .28099 L
s
.75445 .28099 m
.75783 .27606 L
s
.79832 .25323 m
.80438 .254 L
s
.79226 .25313 m
.79832 .25323 L
s
.80438 .254 m
.81033 .25524 L
s
.78631 .25389 m
.79226 .25313 L
s
.81033 .25524 m
.81607 .25667 L
s
.78059 .25561 m
.78631 .25389 L
s
.75783 .27606 m
.76154 .27102 L
s
.7752 .25829 m
.78059 .25561 L
s
.81607 .25667 m
.82152 .25803 L
s
.77021 .26188 m
.7752 .25829 L
s
.76154 .27102 m
.76566 .2662 L
s
.76566 .2662 m
.77021 .26188 L
s
.82152 .25803 m
.82663 .25908 L
s
.82663 .25908 m
.8314 .25958 L
s
.8314 .25958 m
.83582 .25938 L
s
.83582 .25938 m
.83996 .25838 L
s
.83996 .25838 m
.84386 .25656 L
s
.84386 .25656 m
.84763 .25396 L
s
.84763 .25396 m
.85136 .2507 L
s
.85136 .2507 m
.85514 .24696 L
s
.85514 .24696 m
.85906 .24294 L
s
.85906 .24294 m
.8632 .23888 L
s
.8632 .23888 m
.86762 .23501 L
s
.86762 .23501 m
.87233 .23151 L
s
.89383 .22374 m
.8996 .22341 L
s
.88815 .22467 m
.89383 .22374 L
s
.88263 .22627 m
.88815 .22467 L
s
.87734 .22857 m
.88263 .22627 L
s
.8996 .22341 m
.90537 .22355 L
s
.87233 .23151 m
.87734 .22857 L
s
.90537 .22355 m
.91108 .22399 L
s
.91108 .22399 m
.91664 .22454 L
s
.91664 .22454 m
.92202 .22502 L
s
.92202 .22502 m
.92718 .22524 L
s
.25 Mabswid
.84803 0 m
.97045 .1858 L
s
.97045 .1858 m
1 .43991 L
s
1 .43991 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.02708 .28938 m
0 .53839 L
s
0 .53839 m
.87182 .262 L
s
.87182 .262 m
.84803 0 L
s
.84803 0 m
.02708 .28938 L
s
.02708 .28938 m
.84803 0 L
s
.02708 .28938 m
.02639 .29574 L
s
[(0)] .02846 .27668 -0.10874 1 Mshowa
.18611 .23332 m
.18565 .2397 L
s
[(2)] .18704 .22058 -0.07224 1 Mshowa
.35279 .17457 m
.35258 .18096 L
s
[(4)] .35321 .1618 -0.03291 1 Mshowa
.52768 .11292 m
.52774 .11931 L
s
[(6)] .52756 .10014 .00957 1 Mshowa
.71139 .04816 m
.71175 .05454 L
s
[(8)] .71068 .0354 .0556 1 Mshowa
.125 Mabswid
.06615 .27561 m
.06577 .27943 L
s
.10567 .26168 m
.10533 .2655 L
s
.14566 .24758 m
.14535 .25141 L
s
.22705 .2189 m
.22681 .22272 L
s
.26846 .2043 m
.26826 .20812 L
s
.31038 .18952 m
.31021 .19335 L
s
.39572 .15944 m
.39563 .16327 L
s
.43917 .14412 m
.43913 .14796 L
s
.48315 .12862 m
.48315 .13245 L
s
.57275 .09703 m
.57283 .10087 L
s
.61839 .08095 m
.61851 .08478 L
s
.6646 .06466 m
.66477 .06849 L
s
.75878 .03146 m
.75904 .03529 L
s
.80677 .01454 m
.80708 .01837 L
s
.25 Mabswid
.97045 .1858 m
1 .43991 L
s
.97045 .1858 m
.96437 .18777 L
s
[(-1)] .98261 .18188 -1 .32285 Mshowa
.97751 .24654 m
.97142 .24845 L
s
[(-0.5)] .9897 .2427 -1 .31469 Mshowa
.98478 .30908 m
.97867 .31095 L
s
[(0)] .99701 .30533 -1 .30631 Mshowa
.99228 .37351 m
.98615 .37533 L
s
[(0.5)] 1.00453 .36986 -1 .2977 Mshowa
1 .43991 m
.99386 .44169 L
s
[(1)] 1.01228 .43637 -1 .28883 Mshowa
.125 Mabswid
.97184 .19781 m
.96819 .19898 L
s
.97325 .20988 m
.9696 .21105 L
s
.97466 .22203 m
.97101 .22319 L
s
.97608 .23425 m
.97243 .2354 L
s
.97895 .2589 m
.97529 .26004 L
s
.98039 .27133 m
.97673 .27247 L
s
.98185 .28384 m
.97819 .28497 L
s
.98331 .29642 m
.97965 .29755 L
s
.98627 .32181 m
.9826 .32293 L
s
.98775 .33462 m
.98408 .33573 L
s
.98925 .3475 m
.98558 .34861 L
s
.99076 .36046 m
.98709 .36156 L
s
.9938 .38663 m
.99013 .38771 L
s
.99534 .39983 m
.99166 .40091 L
s
.99688 .41311 m
.9932 .41418 L
s
.99844 .42647 m
.99475 .42754 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.875, 191.438},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000_b000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00i_ooool3
o`00033ooooo003Wooooo`03o`000?oooooooooo02oooooo003Oooooo`Go00000oooool00ol0003o
ooooooooo`0_ooooo`00ioooool00ol0003oooooooooo`0_ooooo`00ioooool00ol0003ooooooooo
o`0_ooooo`00i_ooool2o`00037ooooo003Jooooo`?o00002_ooool00ol0003oooooooooo`0_oooo
o`00]_ooool3o`0001oooooo0ol000000ooooooo0000ooooo`0kooooo`00]Oooool01Ol0003ooooo
oooooooooooo000001_ooooo0ol00004ooooo`;o0000>oooool00;Gooooo00Go0000oooooooooooo
ooooo`00000Hooooo`?o00001oooool00ol0003oooooo`00000jooooo`00]_ooool3o`0001Kooooo
0ol0000:ooooo`03o`000?oooooo000003[ooooo002eooooo`05o`000?ooooooooooooooool00000
4_ooool3o`0000;ooooo00?o0000ooooooooool02?ooool01?l0003oooooo`000?l0000iooooo`00
]Oooool01Ol0003ooooooooooooooooo0000013ooooo0_l0000@ooooo`05o`000?oooooooooooooo
ool00000>?ooool00;Kooooo0ol0000>ooooo`?o00004oooool00ol0003oooooooooo`02o`0000go
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000Looooo`00a?ooool3o`0001Kooooo
00?o0000ooooooooool00_l0000<ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooo
ooooooooo`00000Kooooo`00`Oooool3o`000003ooooool0003ooooo01Kooooo00Go0000oooooooo
ooooooooo`000005ooooo`Go00000_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooo
oooo01Wooooo002nooooo`?o00007?ooool01?l0003oooooooooooooool2o`0000_ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`0Iooooo`00^oooool3o`0001oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000Oooooo1?l0
000Looooo`00^?ooool3o`0002;ooooo00?o0000ooooooooool00oooool2o`0000Wooooo00Co0000
oooooooooooo00001oooool00ol0003oooooooooo`0Mooooo`00]_ooool3o`0002Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooo`00000:ooooo`;o00002?ooool5o`0001_ooooo002coooo
o`?o00000_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0<Oooool00;3ooooo0ol0000Zooooo`03o`000?oooooooooo00Gooooo0_l0000booooo`00
[Oooool3o`0002gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0`ooooo`00Z_oo
ool3o`00033ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0_ooooo`00Q_ooool3
o`0001kooooo0ol00002ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool01Oooool2
o`00037ooooo0025ooooo`05o`000?ooooooooooooooool000006oooool2o`0003Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`06ooooo`;o00009_ooool008Gooooo00Go0000oooo
ooooooooooooo`00000Hooooo`?o0000>Oooool00ol0003oooooooooo`07ooooo`;o00001_ooool0
1?l0003oooooooooool0000Uooooo`00QOooool4o`0001Kooooo0ol0000looooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000Uooooo`00QOooool0
0ol0003oooooooooo`0Dooooo`?o000000?oooooo`000?ooool0??ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00009Oooool008Kooooo00?o0000
ooooooooool04?ooool3o`0004;ooooo00?o0000ooooooooool02Oooool2o`0000Cooooo00Co0000
oooooooooooo00009Oooool008Oooooo0_l0000=ooooo`?o0000AOooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00009Oooool009Cooooo0_l00018
ooooo`03o`000?oooooooooo00Wooooo0ol00004ooooo`;o00009_ooool0097ooooo1?l00019oooo
o`03o`000?oooooooooo00Wooooo1?l0000[ooooo`00S_ooool3o`0004gooooo00?o0000ooooool0
00002Ol00003ooooo`;o0000:_ooool008_ooooo0ol0001@ooooo`;o00003_ooool00ol0003ooooo
ooooo`0Xooooo`00R?ooool3o`00053ooooo0ol000000ooooooo0000ooooo`0=ooooo`03o`000?oo
oooooooo02Sooooo0025ooooo`Co0000DOooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00cooooo0_l0000Yooooo`00Poooool2o`0000?ooooo00?o0000ooooooooool0C_ooool2o`00
00Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`06ooooo`;o00001?ooool00ol0
003oooooooooo`02ooooo`?o00004_ooool0083ooooo0ol0001Eooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool03_ooool2o`0000Kooooo00Co0000oooooooooooo00001oooool01Ol0
003ooooooooooooooooo0000017ooooo001mooooo`?o0000Eoooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00oooooo001Jooooo`?o00007Oooool4o`0005Kooooo0ol00008oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00oooooo001Kooooo`03o`000?oooooooooo01Wooooo0ol0001<oooo
o`ko00002oooool00ol0003oooooooooo`0?ooooo`;o00001Oooool01?l0003oooooooooool00007
ooooo`Co00004_ooool005Sooooo1Ol0000Gooooo`?o0000COooool2o`0001Wooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000
ooooooooool04oooool005Sooooo00Co0000oooooooooooo00005Oooool3o`0004kooooo0_l0000K
ooooo`03o`000?oooooooooo013ooooo0ol00004ooooo`;o00002?ooool5o`00017ooooo001Ioooo
o`03o`000?oooooo000001?ooooo0ol0001?ooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0Rooooo`00F_ooool2o`00013ooooo0ol0001Aooooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool04_ooool2o`0002?ooooo001Kooooo`03o`00
0?oooooooooo00_ooooo0ol0001Dooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0
5?ooool00ol0003oooooooooo`0Pooooo`00I_ooool3o`0005Kooooo00?o0000ooooooooool07_oo
ool00ol0003oooooooooo`0Cooooo`;o00008Oooool006?ooooo1?l0001Gooooo`03o`000?oooooo
oooo01oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Oooooo`00H?ooool3o`00
04Wooooo2?l00008ooooo`;o00008_ooool00ol0003oooooooooo`0Dooooo`;o00001oooool3o`00
00?ooooo0ol0000@ooooo`00G_ooool2o`0004[ooooo0_l00008ooooo`So00009?ooool00ol0003o
ooooooooo`0Dooooo`;o00002?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oo
oooo001Kooooo`?o0000Boooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool00oooool5o`0000?ooooo00?o0000ooooooooool03oooool005Sooooo1?l0
001<ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool05_ooool2o`0000Kooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0?ooooo`00EOooool3o`0000?ooooo00?o0000
ooooooooool0B_ooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oooooo001Boooo
o`?o0000D_ooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo01Kooooo0ol00004oooo
o`;o00001?ooool2o`00017ooooo000]ooooo`Go00007Oooool3o`0005Gooooo00?o0000oooooooo
ool0=_ooool00ol0003oooooooooo`0Cooooo`?o00000_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool03oooool002kooooo00Co0000oooooooooooo
00006oooool2o`000003ooooool0003ooooo04;ooooo0_l0000Aooooo`03o`000?oooooooooo03Ko
oooo00?o0000ooooooooool04?ooool3o`0000Gooooo00?o0000ooooooooool06oooool002oooooo
00?o0000ooooooooool06?ooool3o`0004Gooooo0_l00002ooooo`Go00002oooool00ol0003ooooo
ooooo`0gooooo`03o`000?oooooooooo00gooooo0ol00008ooooo`;o00007?ooool0033ooooo00?o
0000ooooooooool05?ooool3o`0004Oooooo00?o0000ooooooooool01oooool4o`0000Gooooo0_l0
000kooooo`03o`000?oooooooooo00Wooooo0ol0000;ooooo`03o`000?oooooooooo01_ooooo000]
ooooo`05o`000?ooooooooooooooool000004_ooool3o`0004[ooooo00?o0000ooooooooool02ooo
ool5o`0003gooooo00?o0000ooooooooool01_ooool3o`0000oooooo00?o0000ooooooooool06_oo
ool002gooooo00Go0000ooooooooooooooooo`00000?ooooo`?o000000?oooooo`000?ooool0BOoo
ool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo00?ooooo0ol0000Booooo`03o`000?oo
oooooooo01[ooooo000^ooooo`?o00003Oooool3o`0004oooooo00?o0000ooooooooool0C_ooool0
0ol0003oooooooooo`03o`0001Cooooo0_l0000Looooo`00??ooool2o`0005;ooooo00?o0000oooo
ooooool0C_ooool3o`0001Sooooo00?o0000ooooooooool06_ooool003Wooooo0ol0000nooooo`Go
00004Oooool00ol0003oooooooooo`1;ooooo`Co00006_ooool00ol0003oooooooooo`0Jooooo`00
=_ooool3o`000003ooooool0003ooooo03gooooo00?o0000ooooooooool00oooool2o`0000kooooo
00?o0000ooooooooool0BOooool3o`0000?ooooo00?o0000ooooooooool03Ol0000;ooooo`03o`00
0?oooooooooo01[ooooo000cooooo`?o0000@oooool00ol0003oooooooooo`05ooooo`?o00002ooo
ool00ol0003oooooooooo`16ooooo`?o00001_ooool00ol0003oooooo`00000Hooooo`03o`000?oo
oooooooo00Wooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00003ooooo`00<?ooool3
o`0004Gooooo00?o0000ooooooooool02Oooool4o`0000Kooooo00?o0000ooooooooool0A?ooool3
o`0000Wooooo0_l0000Iooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo00001ooo
ool01Ol0003ooooooooooooooooo000000;ooooo000]ooooo`Co0000Aoooool00ol0003ooooooooo
o`0=ooooo`;o00001?ooool00ol0003oooooooooo`10ooooo`Co00003?ooool00ol0003ooooooooo
o`0Hooooo`;o00000_ooool5o`0000;ooooo00Co0000oooooooooooo00002oooool1o`00007ooooo
0Oooool002[ooooo0ol00003ooooo`03o`000?oooooooooo04Gooooo00?o0000ooooooooool03ooo
ool4o`00043ooooo0ol0000>ooooo`?o00006oooool00ol0003oooooooooo`07ooooo`04o`000?oo
ooooooooo`0000_ooooo0Ol00001ooooo`7ooooo000Xooooo`;o0000>?ooool3o`0001Cooooo00?o
0000ooooooooool0Coooool3o`00013ooooo00Go0000ooooooooooooooooo`00000Jooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00001oooool4o`0000?ooooo0006ooooo`;o0000
7Oooool3o`0003Wooooo00Co0000oooooooooooooooo1?l0000@ooooo`03o`000?oooooooooo04co
oooo0ol0000Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05oooool2o`0000Wo
oooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`04ooooo`001Oooool01?l0003o
ooooooooool0000Iooooo`Co0000>oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00gooooo00?o0000ooooooooool0BOooool3o`0000Gooooo0ol0000<ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`08ooooo`;o00002?ooool5o`00
00;ooooo0005ooooo`04o`000?ooooooooooo`0001Kooooo0ol0000oooooo`03o`000?oooooooooo
00Kooooo0_l0000=ooooo`03o`000?oooooooooo04Kooooo0ol00005ooooo`?o00000oooool5o`00
00Kooooo0_l00005ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool06Oooool000Go
oooo00Co0000oooooooooooo00004oooool3o`0004;ooooo00?o0000ooooooooool02?ooool3o`00
00[ooooo00?o0000ooooooooool0@oooool3o`0000Kooooo0_l0000;ooooo`Ko00001oooool00ol0
003oooooooooo`0Hooooo`;o00006_ooool000Gooooo00Co0000oooooooooooo00004?ooool3o`00
02gooooo0ol0000Eooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`10ooooo`?o00002?ooool00ol0003oooooooooo`0Fooooo`?o00006_ooool00ol0
003oooooooooo`0Iooooo`001Oooool01?l0003oooooooooool0000>ooooo`;o00000_ooool00ol0
003oooooooooo`0Zooooo`04o`000?ooooooooooooooo`?o00004_ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0?Oooool3o`0000[ooooo00?o0000
ooooooooool05?ooool3o`0000;ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0I
ooooo`001_ooool2o`0000cooooo0ol0000aooooo`03o`000?oooooooooo00Cooooo0_l0000@oooo
o`03o`000?oooooooooo00gooooo1Ol00003ooooo`03o`000?oooooooooo03[ooooo0ol0000<oooo
o`03o`000?oooooooooo01;ooooo0ol00006ooooo`03o`000?oooooooooo01Oooooo0_l0000Joooo
o`004Oooool3o`0003Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0>ooooo`03
o`000?oooooooooo017ooooo0ol0000jooooo`?o00003_ooool00ol0003oooooooooo`0@ooooo`?o
00002_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Sooooo000>ooooo`Co0000
7Oooool4o`0001Gooooo00?o0000ooooooooool01oooool2o`0000kooooo00?o0000ooooooooool0
Boooool3o`00017ooooo00?o0000ooooooooool03Oooool3o`0000kooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`0Hooooo`002oooool3o`00027ooooo00Co0000oooooooooooooooo
0_l0000Dooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`17ooooo`_o00002oooool00ol0003oooooooooo`0:ooooo`Co00004Oooool00ol0003ooooo
ooooo`0Fooooo`03o`000?oooooooooo01Sooooo0008ooooo`?o00009?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02Oooool2o`0000cooooo00?o
0000ooooooooool0@oooool4o`000003ooooool0003o000000Sooooo0ol00007ooooo`03o`000?oo
oooooooo00Sooooo0ol0000Fooooo`03o`000?oooooooooo01Cooooo0_l0000Jooooo`001oooool2
o`0000_ooooo1Ol0000Gooooo`03o`000?oooooooooo00?ooooo0_l0000Booooo`03o`000?oooooo
oooo00[ooooo0_l0000:ooooo`03o`000?oooooooooo043ooooo0ol00004ooooo`03o`000?oooooo
oooo00_ooooo0_l00005ooooo`03o`000?oooooooooo00Gooooo0ol0000Jooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool00oooool2o`0001?ooooo0007ooooo`03o`000?oooooo0000
00[ooooo00?o0000ooooooooool00_ooool2o`0001Gooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo00cooooo0_l00008ooooo`03o`000?oooooooooo
03gooooo0ol00007ooooo`03o`000?oooooooooo00gooooo1Ol00005ooooo`?o00007Oooool00ol0
003oooooooooo`0Dooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00004_ooool0
00Kooooo0_l00002ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0>_ooool3o`00
00Wooooo00?o0000ooooooooool05Oooool3o`00027ooooo00?o0000ooooooooool04oooool2o`00
00?ooooo00Co0000oooooooooooo00004_ooool000Oooooo00Go0000ooooooooooooooooo`000009
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`06
ooooo`;o00003oooool00ol0003oooooooooo`0>ooooo`?o00001Oooool00ol0003oooooooooo`0f
ooooo`?o00002oooool00ol0003oooooooooo`0Cooooo`?o00009Oooool00ol0003oooooooooo`0C
ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`0@ooooo`001oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool2
o`0001;ooooo00?o0000ooooooooool02?ooool2o`0000kooooo00?o0000ooooooooool04?ooool2
o`0000?ooooo00?o0000ooooooooool0<Oooool6o`0000gooooo00?o0000ooooooooool03oooool4
o`0002Wooooo00?o0000ooooooooool04_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o
0000ooooooooool04?ooool000Oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04_ooool3o`0003;ooooo1?l00004
ooooo`;o00002_ooool00ol0003oooooooooo`0=ooooo`?o0000;Oooool00ol0003oooooooooo`0<
ooooo`Oo00000oooool01?l0003oooooooooool0000Booooo`001_ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00Wooooo0_l0000<ooooo`03o`000?oooooooooo04Cooooo0ol00009
ooooo`;o00002?ooool00ol0003oooooooooo`0:ooooo`?o0000<Oooool00ol0003oooooooooo`08
ooooo`?o00001_ooool00ol0003oooooooooo`02ooooo`;o00004oooool000Kooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool0@?ooool4o`0000gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`07oooo
o`?o0000=Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool05oooool000Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00Kooooo0_l0000@ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`0mooooo`?o00000oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool3o`0003Sooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Oooooo0006ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool02oooool2o`0000[ooooo00?o0000ooooooooool0
>Oooool3o`0000Gooooo00?o0000ooooooooool03_ooool2o`0000?ooooo00Co0000oooooooooooo
oooo1?l0000looooo`04o`000?ooooooooooooooo`?o00002oooool00ol0003oooooooooo`0Goooo
o`001_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool02?ooool2o`0000oooooo00?o0000ooooooooool03?ooool2o`0000Sooooo00?o0000oooooooo
ool0:oooool9o`0000;ooooo0ol00008ooooo`03o`000?oooooooooo013ooooo0ol000001?oooooo
0000o`000?l00011ooooo`03o`000?oooooo000000kooooo00?o0000ooooooooool05oooool000Ko
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0=ooooo`;o00001_ooool00ol0003o
ooooooooo`0[ooooo`03o`000?oooooooooo00Gooooo0ol0000:ooooo`03o`000?oooooooooo01;o
oooo0ol00015ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool05_ooool000Kooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo
0_l0000=ooooo`03o`000?oooooooooo00oooooo0_l00005ooooo`03o`000?oooooooooo02Wooooo
00?o0000ooooooooool00oooool3o`0000;ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0?ooooo`?o0000>Oooool4o`0000Wooooo0ol0000?ooooo`;o00006?ooool000Kooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0:?ooool00ol0003oooooooooo`04o`0000Kooooo0_l00007ooooo`03o`000?oo
oooooooo00gooooo0ol0000jooooo`;o00001?ooool9o`0000?ooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`0Fooooo`001_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool02_ooool2o`0000cooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo01;ooooo1_l0000>ooooo`Co00003?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00[ooooo0ol0000kooooo`;o00004oooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo0005ooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool04Oooool2o`000003ooooool0003ooooo01;ooooo0_l00006oooo
o`?o00002Oooool3o`00013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06oooo
o`Co0000??ooool2o`0001Gooooo00?o0000ooooooooool02oooool2o`0001Sooooo0005ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0<ooooo`;o
00002_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`03ooooo`?o000000?oooooo`000?ooool04Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00?ooooo0ol0000oooooo`03o`000?oooooooooo01Ko
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Fooooo`001Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooo000000So00003?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo013ooooo1ol0000>ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
0ol00004ooooo`03o`000?oooooooooo013ooooo00Go0000ooooooooooooooooo`000003ooooo`?o
0000@Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool00oooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo0005ooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03o`0000[ooooo
00?o0000ooooooooool00oooool5o`00013ooooo00?o0000ooooooooool01Oooool2o`0000cooooo
00?o0000ooooooooool02_ooool3o`0000Oooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`04o`0004?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`09ooooo`;o0000
0oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool000Go
oooo00?o0000ooooooooool04Oooool01?l0003oooooo`000?l00005ooooo`03o`000?oooooooooo
00;ooooo0_l00009ooooo`03o`000?oooooo000000;o00001?ooool3o`0000gooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0ol00002oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04_ooool3o`0003Gooooo1Ol0000;oooo
o`03o`000?oooooooooo01_ooooo00?o0000ooooooooool02Oooool2o`0000?ooooo00Co0000oooo
oooooooo00002oooool00ol0003oooooooooo`02ooooo`001Oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Kooooo0ol00007ooooo`04o`000?oooooo0000o`0000_ooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo0ol00006
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03_ooool4o`000003ooooool0003o
000003?ooooo0_l00005ooooo`?o00001oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooo
oooo00Wooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool00_ooool000Gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool2o`0000Gooooo00Co0000
oooooooooooooooo0_l00006ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo0ol0000:ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool03?ooool3o`0003Wooooo00?o0000ooooooooool0
2?ooool7o`00027ooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo000000;o
oooo00?o0000ooooooooool01Oooool4o`0000Gooooo0005ooooo`03o`000?oooooooooo00Gooooo
2?l00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooool000000_l0000=ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool02Oooool3o`0003cooooo00?o0000ooooooooool0<?ooool00ol0003o
ooooooooo`06ooooo`?o00000oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo
00Kooooo0005ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01_ooool3o`0000So
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`00
00Oooooo0_l00004ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00?ooooo0ol0000Aooooo`05o`000?ooooooooooooooool000002?oo
ool3o`0003kooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00;ooooo0_l00008ooooo`Go00001?ooool000Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;o00001oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00002Oooool01Ol0003ooooooooo
oooooooo000000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooo000000?o00005?ooool01?l0003oooooooooool00005ooooo`?o0000@?ooool00ol0003o
ooooooooo`0dooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05Oooool000Cooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo
0_l0000;ooooo`?o000000?oooooo`000?ooool00oooool01Ol0003ooooooooooooooooo0000017o
oooo0ol00003ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooool000000_ooool3o`00033o
oooo0_l0000@ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool01?ooool2o`0001Oo
oooo0004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000007ooooo`03
o`000?oooooooooo00cooooo0_l00005ooooo`03o`000?oooooo000000kooooo1?l00003ooooo`04
o`000?ooooooooooo`0001Kooooo1?l0000booooo`03o`000?oooooooooo00?o00003?ooool00ol0
003oooooooooo`0gooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Oooool000Co
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000oooo
ool000005Oooool2o`0000_ooooo0ol00008ooooo`03o`000?oooooo000001?ooooo1Ol0000coooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0ioooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05Oooool000Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01Oooool01Ol0003ooooooooooooooooo000000Cooooo00Co0000oooooooooooo00005?ooool2
o`0000Sooooo0ol0000;ooooo`03o`000?oooooo0000013ooooo0ol00004ooooo`03o`000?oooooo
oooo033ooooo00?o0000ooooooooool01_ooool2o`0000Oooooo00?o0000ooooooooool0>oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Cooooo0004ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Kooooo00Go0000ooooooooooooooooo`000003ooooo`05o`000?ooooooooooooooool000004ooo
ool2o`0000Gooooo0ol0000?ooooo`;o00003Oooool3o`0000Oooooo0_l0000aooooo`03o`000?oo
oooooooo00Sooooo0_l00003ooooo`;o0000?_ooool00ol0003oooooooooo`03ooooo`;o00005_oo
ool000Cooooo00Go0000ooooooooooooooooo`000008ooooo`Ko00001oooool00ol0003ooooooooo
o`06ooooo`07o`000?ooooooooooooooool0003oooooo`000004ooooo`03o`000?oooooooooo017o
oooo00Co0000ooooool0003ooooo0ol0000Booooo`;o00002_ooool3o`0000_ooooo00?o0000oooo
ooooool0;_ooool00ol0003oooooooooo`0;ooooo`?o0000@Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo01Cooooo0004ooooo`05o`000?ooooooooooooooool000001oooool00ol0
003oooooo`000004ooooo`;o00001Oooool00ol0003oooooooooo`07ooooo`06o`000?oooooooooo
o`000?oooooo00001Oooool00ol0003oooooooooo`0@ooooo`Co00005_ooool00ol0003ooooooooo
o`04ooooo`Co0000:oooool4o`0000oooooo00?o0000ooooooooool0DOooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo01Cooooo0004ooooo`05o`000?ooooooooooooooool000001_oo
ool01?l0003oooooooooool00006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`02o`0000Kooooo00?o0000ooooooooool03Oooool3o`0000?ooooo
00?o0000ooooooooool04oooool01?l0003oooooooooooooool3o`0002kooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo05?ooooo00?o0000oooooooo
ool00_l0000Fooooo`000oooool01Ol0003ooooooooooooooooo000000Oooooo00Co0000oooooooo
oooo00001oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00Co0000oooo
oooooooo00001oooool00ol0003oooooooooo`09ooooo`?o00000_ooool01Ol0003ooooooooooooo
oooo000001Gooooo1?l0000`ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`1Dooooo`05o`000?ooooooooooooooool000005_ooool000?ooooo00Go
0000ooooooooooooooooo`000006ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`08ooooo`04o`000?oooooo0000o`0000Kooooo00?o0000oooo
ooooool01_ooool3o`0000Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0@oooo
o`?o000000?oooooo`000?ooool0;oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool0EOooool01?l0003oooooooooool00004ooooo`?o00003oooool0
00?ooooo00Go0000ooooooooooooooooo`000006ooooo`04o`000?ooooooooooo`0000[ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Oooooo00?o
0000ooooooooool00_ooool3o`0000Sooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0=ooooo`?o00000_ooool00ol0003oooooo`00000Mooooo`;o00004Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0Eoooool01?l0003oooooo`00
0?l00004ooooo`03o`000?oooooooooo00kooooo0003ooooo`05o`000?ooooooooooooooool00000
1Oooool01_l0003ooooooooooooooooo0000ooooo`Go00001?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Sooooo0_l000000ooooooo0000ooooo`06ooooo`Co00002oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo0ol00005ooooo`03o`000?oooooo0000
01_ooooo0_l00002ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo05Sooooo00Co0000ooooool0003o00001?ooool0
0ol0003oooooooooo`0>ooooo`000oooool01?l0003oooooooooool00006ooooo`04o`000?oooooo
ooooooooo`;o00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool01oooool01Ol0003oooooo`000?oooooo000000Cooooo0ol0000>ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool01Oooool4o`0000Wooooo00?o0000ooooool00000
6_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
2Oooool2o`0000Gooooo00?o0000ooooooooool0FOooool00ol0003oooooo`000004ooooo`03o`00
0?oooooooooo00kooooo0003ooooo`04o`000?ooooooooooo`0000Kooooo00Co0000oooooooooooo
oooo0_l00006ooooo`;o00000oooool01Ol0003ooooooooooooooooo000000Wooooo00?o0000oooo
ooooool00_l000001?oooooo0000o`000?l00003ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`?o00003Oooool00ol0003oooooo`00000I
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00;o0000GOooool2o`0000Cooooo00?o0000ooooooooool03_ooool0
00?ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Oooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`06ooooo`04o`000?oo
ooooooooooooo`;o00001_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooool000000_l0000@ooooo`03o`000?oooooo000000Gooooo0_l0000Booooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0=ooooo`;o0000
G_ooool3o`0000?ooooo0_l0000@ooooo`000oooool01?l0003oooooooooool00005ooooo`04o`00
0?ooooooooooooooo`;o00001?ooool2o`0000Cooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`05ooooo`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`0<
ooooo`04o`000?ooooooooooooooo`?o00005?ooool2o`0000Cooooo00Co0000oooooooooooo0000
4?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
J_ooool3o`0000Oooooo00?o0000ooooooooool03_ooool000?ooooo00Co0000oooooooooooo0000
1Oooool01?l0003oooooooooooooool2o`0000?ooooo00?o0000ooooooooool00_l00002ooooo`04
o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo
000000Sooooo00?o0000ooooooooool00oooool2o`0000Kooooo1?l00002ooooo`03o`000?oooooo
oooo00?ooooo0_l0000=ooooo`;o00001?ooool01?l0003oooooooooool0000@ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1Wooooo`Co00006ooo
ool000;ooooo00Go0000ooooooooooooooooo`000005ooooo`04o`000?ooooooooooooooo`;o0000
0oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000002?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooo000000;ooooo1?l00005ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooool000004Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
06Cooooo0ol0000Oooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
oooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000
oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000Kooooo00Go0000oooooooooooo
ooooo`000008ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00ol00003ooooo`03
o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Qooooo`Co00008_ooool000;o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`05o`000?oooooooooooooo
ool000000oooool01?l0003oooooo`000?ooool4o`0000;ooooo00Co0000oooooooooooo00000ooo
ool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000002Oooool01?l0003ooooo
ooooooooool4o`0000Kooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
05kooooo0ol0000Vooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
oooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000Cooooo00?o0000oooo
ool000000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`000009ooooo`Co00000oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00?ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0Foooool4o`0002Wooooo0002ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo
00Co0000ooooool0003ooooo1Ol000001?oooooo0000ooooool00002ooooo`05o`000?oooooooooo
ooooool000001Oooool01Ol0003ooooooooooooooooo000000Oooooo1?l000000ooooooo0000oooo
o`02ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooo`00
0004ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`1Hooooo`?o0000;Oooool000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooo`000?ooool3o`000004oooo
ool0003o0000o`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000001?ooool3o`0000?ooooo00?o0000ooooool000000oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool000001Oooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0E_ooool3o`00
033ooooo0002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool01?l0003o
ooooooooooooool2o`000003ooooool0003ooooo00So000000Koooooo`000?oooooo0000ooooool0
0003ooooo`03o`000?oooooooooo00Cooooo00Co0000ooooool0003ooooo1?l00007ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooo000000Gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool03Oooool4o`0005Gooooo1?l0000cooooo`000_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooooooo
0_l000000ooooooo0000ooooo`07o`000005ooooool0003o0000ooooool000000_ooool01Ol0003o
oooooooooooooooo000000Gooooo1?l0000;ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`03ooooo`;o00001_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`1Soooo
o`?o0000=oooool000;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
00?ooooo0_l000000ooooooo0000ooooo`04o`000003ooooool0003o000000?o00000_ooool00ol0
003oooooo`000003ooooo`04o`000?ooooooooooooooo`?o000000?oooooo`000?ooool02oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool2
o`0000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool0Goooool4o`0003[ooooo00000ooooooo0000ooooo`05oooo
o`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`Go000000?ooooo
o`000?l000000_l000001_oooooo0000ooooool0003oooooo`0000?ooooo1?l00003ooooo`;o0000
3?ooool2o`0000Cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool2o`0000Oo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool0GOooool3o`0003kooooo00000ooooooo0000ooooo`05ooooo`03o`00
0?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`?o000000?oooooo`000?l0
00001?l000001ooooooo0000ooooool0003oooooo`000?ooool00ol00006ooooo`;o00002oooool0
0ol0003oooooo`000004ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_l00007
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo05Wooooo1?l00011ooooo`0000?oooooo`000?ooool01Oooool00ol0
003oooooooooo`02ooooo`04o`000?ooooooooooooooo`;o000000?oooooo`000?ooool02?l00000
0ooooooo0000ooooo`04o`0000;ooooo00?o0000ooooooooool01?ooool2o`0000_ooooo00?o0000
ooooool000001?ooool00ol0003oooooooooo`07ooooo`04o`000?oooooo0000o`0000Sooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool0E_ooool3o`0004Gooooo00000ooooooo0000ooooo`05ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool00_l00002ooooo`;o000000Goooooo`000?l0003o0000oooo
o`06o`0000;ooooo00Co0000oooooooooooo00001_ooool2o`0000_ooooo00?o0000ooooool00000
1?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
Doooool4o`0004Sooooo00000ooooooo0000ooooo`06ooooo`03o`000?oooooooooo00;ooooo00Go
0000ooooooooooooooooo`000002ooooo`;o00000_ooool5o`000004ooooool0003oooooo`0000;o
oooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ool000001Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0D?ooool3o`0004cooooo00000ooooooo0000ooooo`06ooooo`03o`000?oooooooooo00;o
oooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000?o000000Ooooooo`00
0?ooooooooooo`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0C?ooool4o`0004oooooo00000ooooooo0000oooo
o`06ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool3o`0000?ooooo
0_l00002ooooo`03o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000006ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0<ooooo`05
o`000?ooooooooooooooool00000C?ooool3o`0005?ooooo00000ooooooo0000ooooo`06ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00ol000000ooooooo0000ooooo`02o`0000Co
oooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000Kooooo0_l00009
ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03_ooool3o`0004Wooooo1?l0
001Fooooo`0000?oooooo`000?ooool01oooool01?l0003oooooooooooooool4o`000005ooooool0
003oooooooooool000000oooool4o`0000?ooooo00Co0000oooooooooooo00000oooool00ol0003o
ooooooooo`04ooooo`;o00002Oooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
05Oooooo0ol0001Jooooo`0000?o0000ooooooooool01oooool4o`0000;ooooo00?o0000oooooooo
ool00_l00002ooooo`03o`000?oooooooooo00Kooooo00Go0000ooooooooooooooooo`000003oooo
o`03o`000?oooooooooo00Cooooo0_l00009ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool0Doooool4o`0005gooooo00000ol0003oooooooooo`05ooooo`?o00001Oooool00ol0
003oooooooooo`02o`0000?ooooo0_l00005ooooo`;o00000oooool01Ol0003ooooooooooooooooo
000000Kooooo00?o0000ooooool000002?ooool01?l0003oooooooooool00005ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo057ooooo0ol0001Qooooo`0000?o0000ooooooooool00_ooool3o`0000?ooooo00?o0000
ooooooooool00_ooool01_l0003oooooooooool0003oooooo`0000Cooooo0_l000000ooooooo0000
o`000005ooooo`05o`000?ooooooooooooooool000001_ooool01?l0003oooooooooool00007oooo
o`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0C_ooool3o`0006Cooooo00000ol0
003oooooo`000002o`0000Kooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003o
ooooo`0000Gooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000000Gooooo
00Go0000ooooooooooooooooo`000007ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0B_ooool4o`0006Oooooo0002o`0000[ooooo00?o0000ooooooooool00oooool00ol0003o
ooooo`000002ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0B?ooool3o`0006_ooooo0002ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003ooooo`;o
00002Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Kooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0A?ooool4o`0006kooooo0003ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool01?ooool2o`0000Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool01_l0003ooooooooooooooooo0000
ooooo`;o00001_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`11ooooo`?o0000L_ooool000Cooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`04ooooo`;o00001Oooool3o`0000;ooooo0_l00006oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool5o`0000Wooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0=ooooo`04o`000?ooooooooooo`00043ooooo1?l0001e
ooooo`001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo0_l00008oooo
o`;o00001oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Oooooo0_l0000:oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03Oooool01?l0003oooooooooool0000m
ooooo`?o0000NOooool000Kooooo0_l00006ooooo`03o`000?oooooooooo00Cooooo0_l0000@oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03_ooool2o`0003[ooooo1?l0001loooo
o`002?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo0_l0000?ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0Aoooool3o`00083ooooo0009ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0A?ooool4o`0008?ooooo000:ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01Oooool2o`0000cooooo00?o0000ooooooooool01?oo
ool2o`0000Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo047ooooo0ol00027ooooo`002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooool000002_ooool00ol0003oooooooooo`05ooooo`;o00002Oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0?Oooool4
o`0008[ooooo000<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooo`000006ooooo`?o00002?ooool3o`0000Oooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo03[ooooo0ol0002>ooooo`003Oooool2o`0000?o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06o`0000_ooooo0ol00007ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0fooooo`Co
0000TOooool000oooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0?ooooo`Co
00001oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0=?ooool3o`0009Gooooo000@ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooooooo
ool03_ooool4o`0000Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo033ooooo1?l0002Hooooo`004Oooool01?l0003oooooooooool00006ooooo`03
o`000?oooooooooo00kooooo1?l00007ooooo`03o`000?oooooooooo00cooooo00Go0000oooooooo
ooooooooo`00000_ooooo`?o0000W?ooool001;ooooo00Co0000oooooooooooo00001_ooool00ol0
003oooooooooo`0<ooooo`?o000000?oooooo`000?ooool01_ooool00ol0003oooooooooo`0<oooo
o`04o`000?ooooooooooo`0002gooooo0ol0002Oooooo`004oooool2o`000003ooooool0003ooooo
00Gooooo0_l0000<ooooo`?o000000?oooooo`000?ooool01_ooool00ol0003oooooooooo`0<oooo
o`04o`000?ooooooooooo`0002Wooooo1?l0002Rooooo`005Oooool00ol0003oooooo`000007oooo
o`03o`000?oooooooooo00Sooooo00Ko0000ooooool0003o0000ooooool00006ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooool000009_ooool3o`000:Kooooo000Fooooo`04o`000?oooooo
0000o`0000Kooooo00?o0000ooooooooool01oooool2o`000004ooooool0003oooooo`0000Kooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0Qooooo`Co0000ZOooool001Oooooo00?o
0000ooooooooool00_l00005ooooo`03o`000?oooooooooo00Cooooo0_l00003ooooo`03o`000?oo
oooo000000Kooooo00?o0000ooooooooool0<?ooool3o`000:gooooo000Hooooo`04o`000?oooooo
ooooooooo`;o00001?ooool7o`0000Cooooo00?o0000ooooool000001Oooool00ol0003ooooooooo
o`0]ooooo`Co0000/?ooool001Wooooo0_l00003ooooo`Co00000oooool3o`0000Gooooo00?o0000
ooooool000001Oooool00ol0003oooooooooo`0Zooooo`?o0000]?ooool001_ooooo00?o0000oooo
ooooool01?ooool3o`0000Sooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`0Voooo
o`Co0000]oooool001cooooo00?o0000ooooooooool03_ooool00ol0003oooooo`000005ooooo`03
o`000?oooooooooo02?ooooo0ol0002kooooo`007Oooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooo000000Gooooo00?o0000ooooooooool07oooool4o`000;kooooo000Nooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`0Mooooo`?o0000`_oo
ool001oooooo0_l0000<ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool06Ooo
ool4o`000<Gooooo000Qooooo`03o`000?oooooooooo00Wooooo00Co0000oooooooooooo00000ooo
ool00ol0003oooooooooo`0Fooooo`?o0000bOooool002;ooooo00?o0000ooooooooool02?ooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooooooo01;ooooo1?l0003<ooooo`008oooool0
0ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool04?oo
ool3o`000=3ooooo000Tooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooooooo00gooooo0ol0003Cooooo`009Oooool00ol0003oooooooooo`04
ooooo`07o`000?ooooooooooooooool0003oooooo`00000<ooooo`Co0000e_ooool002Kooooo0_l0
0004ooooo`07o`000?ooooooooooooooool0003oooooo`000009ooooo`?o0000f_ooool002Sooooo
00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Cooooo1?l0003Mooooo`00
:Oooool01?l0003oooooooooool00008ooooo`?o0000hOooool002[ooooo00?o0000ooooool00000
1?ooool4o`000>Cooooo000[ooooo`;o000000Coooooo`000?l0003o0000j?ooool002cooooo0_l0
003[ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00\
\>"],
  ImageRangeCache->{{{0, 280.875}, {190.438, 0}} -> {0.0219893, 0.106871, \
0.00376814, 0.00376814}}]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{526, 479},
WindowMargins->{{36, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 110, 3, 65, "Subtitle",
  Evaluatable->False],
Cell[1889, 58, 530, 9, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2444, 71, 110, 2, 56, "Section",
  Evaluatable->False],
Cell[2557, 75, 89, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2683, 82, 96, 2, 36, "Section",
  Evaluatable->False],
Cell[2782, 86, 244, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3051, 95, 338, 7, 88, "Input"],
Cell[3392, 104, 38880, 1384, 200, 13024, 1059, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[42321, 1494, 101, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[42447, 1500, 98, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[42570, 1506, 306, 6, 88, "Input"],
Cell[42879, 1514, 37922, 1372, 200, 13030, 1059, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[80850, 2892, 99, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[80974, 2898, 301, 6, 88, "Input"],
Cell[81278, 2906, 40631, 1405, 200, 13038, 1059, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[121970, 4318, 106, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[122101, 4324, 338, 7, 88, "Input"],
Cell[122442, 4333, 40072, 1398, 200, 13054, 1059, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[162563, 5737, 108, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[162696, 5743, 85, 2, 27, "Input"],
Cell[162784, 5747, 75616, 3296, 200, 31920, 2751, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

